package com.gingersoft.gsa.cloud.meal.mvp.model.service;

import com.gingersoft.gsa.cloud.base.bean.BaseRespose;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.meal.mvp.model.bean.request.SendOrderRequest;

import java.util.List;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.POST;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface MealService {

    @POST("order/send" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> sendOrder(@Body List<SendOrderRequest> foods);

    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> addFood(@Body RequestBody requestBody);

    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> loadOrder(@Body RequestBody requestBody);

    @POST("orderDetails/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> deleteFood(@Body RequestBody requestBody);
}
