package com.gingersoft.gsa.cloud.meal.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.meal.R;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import androidx.recyclerview.widget.GridLayoutManager;

public class HorizontalGridViewAdpter extends BaseAdapter {

    private Context context;
    private List<Food> lists;//数据源
    private int mIndex; // 页数下标，标示第几页，从0开始
    private int mPargerSize;// 每页显示的最大的数量

    private int currentSelectPosition;

    public HorizontalGridViewAdpter(Context context, List<Food> lists, int mIndex, int mPargerSize) {
        this.context = context;
        this.lists = lists;
        this.mIndex = mIndex;
        this.mPargerSize = mPargerSize;
    }

    /**
     * 先判断数据及的大小是否显示满本页lists.size() > (mIndex + 1)*mPagerSize
     * 如果满足，则此页就显示最大数量lists的个数
     * 如果不够显示每页的最大数量，那么剩下几个就显示几个
     */
    @Override
    public int getCount() {
        return lists.size() > (mIndex + 1) * mPargerSize ?
                mPargerSize : (lists.size() - mIndex * mPargerSize);
    }

    @Override
    public Food getItem(int arg0) {
        return lists.get(arg0 + mIndex * mPargerSize);
    }

    @Override
    public long getItemId(int arg0) {
        return arg0 + mIndex * mPargerSize;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        //重新确定position因为拿到的总是数据源，数据源是分页加载到每页的GridView上的
        final int pos = position + mIndex * mPargerSize;//假设mPageSiez
        Food food = lists.get(pos);

        final ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = View.inflate(context, R.layout.meal_item_name, null);
            holder.tv_name = (TextView) convertView.findViewById(R.id.tv_text);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        //假设mPagerSize=8，假如点击的是第二页（即mIndex=1）上的第二个位置item(position=1),那么这个item的实际位置就是pos=9
        holder.tv_name.setText(lists.get(pos).getFoodName());

        if (food.isSelected()){
            holder.tv_name.setBackgroundColor(context.getResources().getColor(R.color.orange_500));
        }else {
            holder.tv_name.setBackgroundColor(ArmsUtils.getColor(context, R.color.Grass_green));
        }

        holder.tv_name.setMaxHeight(100);
        holder.tv_name.setHeight(ArmsUtils.dip2px(context, 40));

//        ViewGroup.LayoutParams layoutParams = (ViewGroup.LayoutParams) holder.tv_name.getLayoutParams();
//        layoutParams.height = 40;
//        holder.tv_name.setLayoutParams(layoutParams);

        holder.tv_name.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                Food food = lists.get(pos);

                if (currentSelectPosition != pos) {
                    //设置当前选中item颜色
                    food.setSelected(true);

                    if (currentSelectPosition < lists.size()) {
                        //重置上次选中item的颜色
                        lists.get(currentSelectPosition).setSelected(false);
                    }

                    notifyDataSetChanged();

                    //保存上次操作的position
                    currentSelectPosition = pos;

                    if (mOnItemClickListener != null)
                        mOnItemClickListener.onItemClick(food, pos);
                }

            }
        });
        return convertView;
    }

    static class ViewHolder {
        private TextView tv_name;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Food food, int position);

    }
}
