package com.gingersoft.gsa.cloud.database.greendao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Function;

import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig foodDaoConfig;
    private final DaoConfig functionDaoConfig;

    private final FoodDao foodDao;
    private final FunctionDao functionDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        foodDaoConfig = daoConfigMap.get(FoodDao.class).clone();
        foodDaoConfig.initIdentityScope(type);

        functionDaoConfig = daoConfigMap.get(FunctionDao.class).clone();
        functionDaoConfig.initIdentityScope(type);

        foodDao = new FoodDao(foodDaoConfig, this);
        functionDao = new FunctionDao(functionDaoConfig, this);

        registerDao(Food.class, foodDao);
        registerDao(Function.class, functionDao);
    }
    
    public void clear() {
        foodDaoConfig.clearIdentityScope();
        functionDaoConfig.clearIdentityScope();
    }

    public FoodDao getFoodDao() {
        return foodDao;
    }

    public FunctionDao getFunctionDao() {
        return functionDao;
    }

}
