package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.constans.OrderTypeConstans;
import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.util.PayMethodUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */
public class OrderCenterAdapter extends DefaultAdapter<OrderManagerResponse> {

    private Context mContext;

    public OrderCenterAdapter(Context context, List<OrderManagerResponse> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<OrderManagerResponse> getHolder(View v, int viewType) {
        return new OrderCenterItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_order_center;
    }

    class OrderCenterItemHolder extends BaseHolder<OrderManagerResponse> {

        @BindView(R2.id.ll_root_container)
        LinearLayout ll_root_container;
        @BindView(R2.id.tv_table_name)
        TextView tv_table_name;
        @BindView(R2.id.tv_order_num)
        TextView tv_order_num;
        @BindView(R2.id.tv_people_num)
        TextView tv_people_num;
        @BindView(R2.id.tv_open_time)
        TextView tv_open_time;
        @BindView(R2.id.tv_pay_time)
        TextView tv_pay_time;
        @BindView(R2.id.tv_pay_money)
        TextView tv_pay_money;

        @BindView(R2.id.btn_print_order)
        QMUIAlphaButton btn_print_order;
        @BindView(R2.id.btn_tips)
        QMUIAlphaButton btn_tips;
        @BindView(R2.id.btn_refund)
        QMUIAlphaButton btn_refund;
        @BindView(R2.id.btn_modify_order)
        QMUIAlphaButton btn_modify_order;
        @BindView(R2.id.btn_cancel_order)
        QMUIAlphaButton btn_cancel_order;
        @BindView(R2.id.btn_order_status)
        QMUIAlphaButton btn_order_status;
        @BindView(R2.id.ll_bottom)
        LinearLayout ll_bottom;
        @BindView(R2.id.ll_pos_bottom)
        LinearLayout ll_pos_bottom;

        public OrderCenterItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(OrderManagerResponse item, int position) {

            setOrderItemDetail(item);
            setBtnVisibility(item, position);
            setBtnListener(item, position);
            btn_refund.setVisibility(View.GONE);

            ll_root_container.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(item, position);
                    }
                }
            });
        }

        private void setOrderItemDetail(OrderManagerResponse item) {
            String pax = LanguageUtils.get_language_system(mContext, "Meal.Mannumber", "人數") + "：";
            String openTable = LanguageUtils.get_language_system(mContext, "open.table", "開台") + "：";
            String payTable = LanguageUtils.get_language_system(mContext, "open.table", "結賬") + "：";
            String amount = LanguageUtils.get_language_system(mContext, "amount", "金額") + "：$";
            String orderCode = LanguageUtils.get_language_system(mContext, "order.code", "訂單碼") + ": ";
            String mealCode = LanguageUtils.get_language_system(mContext, "meal.code", "取餐碼") + ": ";

            tv_people_num.setText(pax + item.getPerson());
            tv_open_time.setText(openTable + TimeUtils.getStringByFormat(new Date(item.getCreateTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
            if (!TextUtils.isEmpty(item.getEndTime())) {
                tv_pay_time.setText(payTable + TimeUtils.getStringByFormat(new Date(item.getEndTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
            }
            tv_pay_money.setText(amount + item.getTotalAmount());
            btn_print_order.setText(LanguageUtils.get_language_system(mContext, "print.order", "打印賬單"));
            btn_tips.setText(LanguageUtils.get_language_system(mContext, "public.tips", "貼士"));
            btn_modify_order.setText(LanguageUtils.get_language_system(mContext, "modify.order", "修改訂單"));
            btn_cancel_order.setText(LanguageUtils.get_language_system(mContext, "cancel.order", "取消訂單"));
            if (item.getOrderType() == OrderTypeConstans.order_type_2) {
                tv_table_name.setText("外賣");
                tv_order_num.setText(orderCode + item.getTakeFoodCode());
            } else if (item.getOrderType() == OrderTypeConstans.order_type_7) {
                tv_table_name.setText("自取");
                tv_order_num.setText(orderCode + item.getBillNo() + "  " + mealCode + item.getTakeFoodCode());
            } else {
                String tableName = LanguageUtils.get_language_system(mContext, "table.number", "檯號") + ": ";
                String orderNumber = LanguageUtils.get_language_system(mContext, "order.number", "訂單號") + ": ";
                tv_table_name.setText(tableName + item.getTableName());
                tv_order_num.setText(orderNumber + item.getId());
            }
        }

        private void setBtnVisibility(OrderManagerResponse item, int position) {
            List<OrderManagerResponse.OrderPayBean> orderPays = item.getOrderPays();
            if (orderPays != null && orderPays.size() > 0) {
                List<PayMethod> payMethods = new ArrayList<>();
                for (OrderManagerResponse.OrderPayBean orderPayBean : orderPays) {
                    PayMethod payMethod = new PayMethod();
                    payMethod.setPayType(orderPayBean.getPayType());
                    payMethod.setPayMoney(orderPayBean.getAmount());
                    payMethod.setTipsPrice(orderPayBean.getTipsPrice());
                    payMethods.add(payMethod);
                }
                PayMethod payMethod = PayMethodUtils.filterPaymentMethodById(payMethods, PayMethod.HYWEB_POS_TYPE_CC);
                if (payMethod != null) {
                    //只有卡片支付才支持補小費
                    btn_tips.setVisibility(View.VISIBLE);
                } else {
                    btn_tips.setVisibility(View.GONE);
                }
            }
            if (item.getStatus() == 6) {
                btn_print_order.setVisibility(View.GONE);
                btn_modify_order.setVisibility(View.GONE);
                btn_cancel_order.setVisibility(View.GONE);
                btn_order_status.setVisibility(View.VISIBLE);
                ll_pos_bottom.setVisibility(View.GONE);
            } else {
                btn_print_order.setVisibility(View.VISIBLE);
                btn_modify_order.setVisibility(View.VISIBLE);
                btn_cancel_order.setVisibility(View.VISIBLE);
                btn_order_status.setVisibility(View.GONE);
                if (AppDevices.isHywebPos() && item.withHywebPay()) {
                    setOrderStatusByTxnId(item.getPayTxnId(), item.getCancelTxnId(), item.getRefundTxnId());
                    ll_pos_bottom.setVisibility(View.VISIBLE);
                } else {
                    ll_pos_bottom.setVisibility(View.GONE);
                }
            }
            int orderType = item.getOrderType();
            if (orderType == OrderTypeConstans.order_type_2 || orderType == OrderTypeConstans.order_type_7) {
                //外賣自取 不可以修改訂單 取消訂單
                btn_modify_order.setVisibility(View.GONE);
                btn_cancel_order.setVisibility(View.GONE);
            }
        }

        private void setBtnListener(OrderManagerResponse item, int position) {
            if (item.getStatus() != 6) {
                btn_print_order.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onPrintClick(item, position);
                        }
                    }
                });
                btn_modify_order.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onModifyClick(item, position);
                        }
                    }
                });
                btn_cancel_order.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onCancelClick(item, position);
                        }
                    }
                });
                btn_refund.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onRefundClick(item, position);
                        }
                    }
                });
                btn_tips.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onTipsClick(item, position);
                        }
                    }
                });
            }
        }

        private void setOrderStatusByTxnId(String payTxnId, String cancelTxnId, String refundTxnId) {
            if (!TextUtils.isEmpty(cancelTxnId)) {
                btn_order_status.setText("已取消");
                btn_order_status.setVisibility(View.VISIBLE);
                setOrderCancelVisbility();
                return;
            }
            if (!TextUtils.isEmpty(refundTxnId)) {
                btn_order_status.setVisibility(View.VISIBLE);
                btn_order_status.setText("已退款");
                setOrderCancelVisbility();
                return;
            }
            if (!TextUtils.isEmpty(payTxnId)) {
                btn_print_order.setVisibility(View.VISIBLE);
                btn_refund.setVisibility(View.VISIBLE);
                btn_cancel_order.setVisibility(View.VISIBLE);
                btn_modify_order.setVisibility(View.VISIBLE);
            }
        }

        private void setOrderCancelVisbility() {
            btn_print_order.setVisibility(View.GONE);
            btn_modify_order.setVisibility(View.GONE);
            btn_refund.setVisibility(View.GONE);
            btn_tips.setVisibility(View.GONE);
        }
    }


    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(OrderManagerResponse datasBean, int position);

        void onPrintClick(OrderManagerResponse datasBean, int position);

        void onModifyClick(OrderManagerResponse datasBean, int position);

        void onCancelClick(OrderManagerResponse datasBean, int position);

        void onRefundClick(OrderManagerResponse datasBean, int position);

        void onTipsClick(OrderManagerResponse datasBean, int position);
    }
}
