package com.gingersoft.gsa.cloud.common.utils;


import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class StringUtils {

    public static final String DEFAULT_QUERY_REGEX = "[!$^&*+=|{}';'\",<>/?~！#￥%……&*——|{}【】‘；：”“'。，、？]";

    /**
     * 生成指定长度字符串，不足位右补空格，超出換行
     *
     * @param value
     * @param totalLen
     * @return
     */
    public static String[] formatOrderPrintRow(String value, int totalLen) {

        String[] strs = new String[2];
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
            } else {
                valueLength += 1;
            }
        }
        if (totalLen > valueLength) {
            int temp = totalLen - valueLength;
            for (int i = 0; i < temp; i++) {
                value += " ";
            }
            strs[0] = value;
        } else {
            String startValue = value.substring(0, 9);
            String endValue = value.substring(9, value.length());
            strs[0] = startValue;
            strs[1] = endValue;
        }
        return strs;
    }

    public static String rightMakeupSpace(String value, int totalLen) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
            } else {
                valueLength += 1;
            }
        }
        if (totalLen > valueLength) {
            int temp = totalLen - valueLength;
            for (int i = 0; i < temp; i++) {
                value += " ";
            }
        }
        return value;
    }

    public static String leftMakeupSpace(String value, int totalLen) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
            } else {
                valueLength += 1;
            }
        }
        if (totalLen > valueLength) {
            int temp = totalLen - valueLength;
            for (int i = 0; i < temp; i++) {
                value = " " + value;
            }
        }
        return value;
    }

    public static int getChineseValueLength(String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }


    /**
     * 给定一个长字符串内容，返回一个数组
     *
     * @param content 所有的内容
     * @param count   需要每段截取的长度
     * @return 所有分段的数组list
     */
    public static List<String> getListFromContent(String content, int count) {

        List<String> list = new ArrayList<>();
        // 获取String的总长度
        int contentLength = content.length();

        if (contentLength < count) {
            list.add(content);
        } else {

            int begin = 0;
            // 获取需要切割多少段
            int cutCount = contentLength / count;

            int cutCounts = contentLength % count;

            // 获取切割段的长度
            if (cutCounts != 0) {
                cutCount++;
            }

            for (int i = 1; i <= cutCount; i++) {
                String temp;
                // 不是最后一段
                if (i != cutCount) {

                    temp = content.substring(begin, count * i);

                } else {
                    temp = content.substring(begin, contentLength);
                }

                begin = count * i;
                list.add(temp);
            }
        }
        return list;
    }

    /**
     * @param content
     * @param begin
     * @param end
     * @return
     */
    public static String getPhoneByBlurCharAfter(String content, int begin, int end) {

        if (begin >= content.length() || begin < 0) {
            return content;
        }
        if (end >= content.length() || end < 0) {
            return content;
        }
        if (begin >= end) {
            return content;
        }
        String starStr = "";
        for (int i = begin; i < end; i++) {
//            starStr = starStr + GSAApplication.androidSetting.getvBlurChar();
        }
        return content.substring(0, begin) + starStr + content.substring(end, content.length());
    }


    /**
     * 超出的字符串使用替代符顯示（...）
     *
     * @param value
     * @param omitBlur
     * @param needOmitLength
     * @return
     */
    public static String getEllipsizeStringByOmitBlur(String value, String omitBlur, int needOmitLength) {

        if (value.length() > needOmitLength) {
            return value.substring(0, needOmitLength - 1) + omitBlur;
        }

        return value;
    }

    /**
     * 特殊字符转义处理
     *
     * @param data
     * @return
     */
    public static String stringEscape(String data) {
        data = data.replace(" ", "%20");
        data = data.replace("\"", "%22");
        data = data.replace("#", "%23");
        data = data.replace("%", "%25");
        data = data.replace("&", "%26");
        data = data.replace("(", "%28");
        data = data.replace(")", "%29");
        data = data.replace("+", "%2B");
        data = data.replace(",", "%2C");
        data = data.replace("/", "%2F");
        data = data.replace(":", "%3A");
        data = data.replace(";", "%3B");
        data = data.replace("<", "%3C");
        data = data.replace("=", "%3D");
        data = data.replace(">", "%3E");
        data = data.replace("?", "%3F");
        data = data.replace("@", "%40");
        data = data.replace("\\ ", "%5C");
        data = data.replace("|", "%7C");
        return data;
    }


    /**
     * 判断是否含有特殊字符
     *
     * @param str
     * @return true为包含，false为不包含
     */
    public static boolean isSpecialChar(String str) {
        String regEx = "[ _`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    /**
     * 判断查询参数中是否以特殊字符开头，如果以特殊字符开头则返回true，否则返回false
     *
     * @param value
     * @return
     * @see {@link #getQueryRegex()}
     * @see {@link #DEFAULT_QUERY_REGEX}
     */
    public boolean specialSymbols(String value) {
        if (value.equals(" ")) {
            return false;
        }
        Pattern pattern = Pattern.compile(getQueryRegex());
        Matcher matcher = pattern.matcher(value);

        char[] specialSymbols = getQueryRegex().toCharArray();

        boolean isStartWithSpecialSymbol = false; // 是否以特殊字符开头
        for (int i = 0; i < specialSymbols.length; i++) {
            char c = specialSymbols[i];
            if (value.indexOf(c) == 0) {
                isStartWithSpecialSymbol = true;
                break;
            }
        }

        return matcher.find() && isStartWithSpecialSymbol;
    }


    /**
     * 获取查询过滤的非法字符
     *
     * @return
     */
    protected String getQueryRegex() {
        return DEFAULT_QUERY_REGEX;
    }


    /**
     * 方法二：推荐，速度最快
     * 判断是否为整数
     * @param str 传入的字符串
     * @return 是整数返回true, 否则返回false
     */
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }
}