package com.gingersoft.gsa.cloud.pay.pos;

import android.content.Context;

import com.etps.aca.lib.activity.CommandActivity;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.order.bean.request.MealOrderPayRequest;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.AdjustTipRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.RefundRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.RetrievalRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.SaleRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.VoidRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.command.CommandImpl;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp.RefundActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp.RetrievalActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp.SaleActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp.TipsActionImpl;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp.VoidActionImpl;
import com.jess.arms.mvp.IView;

import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:32
 * @更新時間: 2020-12-26 10:32
 * @描述:
 */
public final class PosPay {

    public static void sendRequest(IPosAction action) {
        CommandActivity.setCommand(new CommandImpl(action));
//        if (AppDevice.isHywebPos()) {
        if (action != null) {
            action.onPosActionBefore();
        }
//        } else if (AppDevice.isBBPos()) {
//        } else {
//        }
    }

    public static void pay(Context context, IView iView, SaleRequest saleRequest, GetTxnIdRequest getTxnIdRequest, TableBean.DataBean tableBean, MealOrderPayRequest orderPayRequest, List<BillItem> billItemList, List<PayMethod> payMethodList, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new SaleActionImpl(context, iView, PosAction.SALE, saleRequest, getTxnIdRequest, tableBean, orderPayRequest, billItemList, payMethodList, onPosActionListener,true));
    }

    public static void tip(Context context, IView iView, GetTxnIdRequest txnIdRequest, AdjustTipRequest tipRequest, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new TipsActionImpl(context, iView, PosAction.TIP, txnIdRequest, tipRequest, onPosActionListener, true));
    }

    public static void refund(Context context, IView iView, RefundRequest request, GetTxnIdRequest getTxnIdRequest, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new RefundActionImpl(context, iView, PosAction.REFUND, request, getTxnIdRequest, onPosActionListener, true));
    }

    public static void voidO(Context context, IView iView, VoidRequest request, GetTxnIdRequest getTxnIdRequest, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new VoidActionImpl(context, iView, PosAction.VOID, request, getTxnIdRequest, onPosActionListener, true));
    }

    public static void retrieval(Context context, IView iView,Long orderId, PosAction retrievalAction, RetrievalRequest request, OnPosActionListener onPosActionListener) {
        PosPay.sendRequest(new RetrievalActionImpl(context, iView, PosAction.RETRIEVAL,retrievalAction, orderId, request, onPosActionListener, false));
    }

}
