package com.gingersoft.gsa.cloud.pay.util;

import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.contract.PayTypeContract;

import java.util.ArrayList;
import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2020-12-28 10:36
 * @更新時間: 2020-12-28 10:36
 * @描述:
 */
public class PayMethodUtils {


    public static List<PayMethod> filterPaymentsMethodById(List<PayMethod> payMethods, int[] types) {
        List<PayMethod> payMethodList = new ArrayList<>();
        if (payMethods != null && payMethods.size() > 0 && types.length > 0) {
            for (int type : types) {
                for (PayMethod payMethod : payMethods) {
                    if (payMethod.getPayType() == type) {
                        payMethodList.add(payMethod);
                    }
                }
            }
        }
        return payMethodList;
    }

    public static PayMethod filterPaymentMethodById(List<PayMethod> payMethods, int type) {
        if (payMethods != null && payMethods.size() > 0 && type != 0) {
            for (PayMethod payMethod : payMethods) {
                if (payMethod.getPayType() == type) {
                    return payMethod;
                }
            }
        }
        return null;
    }

    /**
     * 存在hyweb支付方式
     *
     * @param payMethods
     * @return
     */
    public static int hasHywebPayMethod(List<PayMethod> payMethods) {
        if (payMethods != null && payMethods.size() > 0) {
            int[] payTypes = {PayTypeContract.PAY_METHOD_ID_1030, PayTypeContract.PAY_METHOD_ID_1031};
            for (int i = 0; i < payMethods.size(); i++) {
                PayMethod payMethod = payMethods.get(i);
                if (payMethod.getPayType() == payTypes[0] || payMethod.getPayType() == payTypes[1]) {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean withHywebPayMethod(PayMethod payMethod) {
        int[] payTypes = {PayTypeContract.PAY_METHOD_ID_1030, PayTypeContract.PAY_METHOD_ID_1031};
        if (payMethod.getPayType() == payTypes[0] || payMethod.getPayType() == payTypes[1]) {
            return true;
        }
        return false;
    }

    /**
     * 獲取Hyweb支付
     * @param payMethods
     * @return
     */
    public static PayMethod getHywebPayMethod(List<PayMethod> payMethods) {
        if (payMethods != null && payMethods.size() > 0) {
            int[] payTypes = {PayTypeContract.PAY_METHOD_ID_1030, PayTypeContract.PAY_METHOD_ID_1031};
            for (int i = 0; i < payMethods.size(); i++) {
                PayMethod payMethod = payMethods.get(i);
                if (payMethod.getPayType() == payTypes[0] || payMethod.getPayType() == payTypes[1]) {
                    return payMethod;
                }
            }
        }
        return null;
    }

}
