package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.gingersoft.supply_chain.mvp.contract.ShoppingCatContract;
import com.gingersoft.supply_chain.mvp.ui.fragment.order.ShoppingCatFragment;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.ShoppingCatModule;

import com.jess.arms.di.scope.FragmentScope;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/03/2020 17:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = ShoppingCatModule.class, dependencies = AppComponent.class)
public interface ShoppingCatComponent {
    void inject(ShoppingCatFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        Builder view(ShoppingCatContract.View view);

        Builder appComponent(AppComponent appComponent);

        ShoppingCatComponent build();
    }
}