package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.WarehouseDetailsContract;

import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/21/2021 10:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class WarehouseDetailsModel extends BaseModel implements WarehouseDetailsContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public WarehouseDetailsModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getWarehousingOrderDetails(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getWarehousingOrderDetails(map);
    }

    @Override
    public Observable<BaseResult> getWarehouseInventoryReason() {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getWarehouseInventoryReason();
    }
}