package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.SendSupplierMsgBean;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean.SupplierContacts.getContractPicByType;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/29
 * Time: 10:38
 * Use:
 */
public class SendSupplierMsgAdapter extends BaseQuickAdapter<SendSupplierMsgBean, BaseViewHolder> {

    public SendSupplierMsgAdapter(List<SendSupplierMsgBean> sendSupplierMsgBeans) {
        super(R.layout.item_supplier_send_msg, sendSupplierMsgBeans);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, SendSupplierMsgBean sendSupplierMsgBean) {
        viewHolder.setText(R.id.tv_item_send_supplier_msg_supplier_name, sendSupplierMsgBean.getSupplierName());
        viewHolder.setGone(R.id.tv_supplier_send_state, !sendSupplierMsgBean.isSend());
        RecyclerView rvContacts = viewHolder.getView(R.id.rv_item_send_supplier_msg);
        ContactsListAdapter contactsListAdapter = new ContactsListAdapter(sendSupplierMsgBean.getSupplierContacts());
        contactsListAdapter.setOnItemClickListener((adapter, view, position) -> {
            contactsListAdapter.setSelectIndex(position);
            contactsListAdapter.notifyItemChanged(sendSupplierMsgBean.getCheckPosition());
            contactsListAdapter.notifyItemChanged(position);
            sendSupplierMsgBean.setCheckPosition(position);
        });
        rvContacts.setAdapter(contactsListAdapter);
        LinearLayout contactsLayout = viewHolder.getView(R.id.layout_send_supplier_msg_hide_show);
        viewHolder.setGone(R.id.layout_send_supplier_msg_hide_show, !sendSupplierMsgBean.isOpen());
        viewHolder.getView(R.id.layout_open_hide_send_supplier_msg).setOnClickListener(v -> contactsLayout.setVisibility(View.GONE));
        viewHolder.getView(R.id.tv_item_send_supplier_msg_supplier_name).setOnClickListener(v -> {
            OnItemClickListener onItemClickListener = getOnItemClickListener();
            if (onItemClickListener != null) {
                onItemClickListener.onItemClick(this, v, viewHolder.getAdapterPosition());
            }
            contactsLayout.setVisibility(View.VISIBLE);
        });
    }

    public static class ContactsListAdapter extends BaseQuickAdapter<SupplierInfoBean.SupplierContacts, BaseViewHolder> {
        private int selectIndex = -1;

        public ContactsListAdapter(@Nullable List<SupplierInfoBean.SupplierContacts> data) {
            super(R.layout.item_pic_radio, data);
        }

        @Override
        protected void convert(@NotNull BaseViewHolder viewHolder, SupplierInfoBean.SupplierContacts item) {
            RadioButton radioButton = viewHolder.getView(R.id.rb_item_pic_radio_title_radio);
            if (selectIndex == -1) {
                radioButton.setChecked(item.isDefault());
                if (getData().size() == 1) {
                    selectIndex = 0;
                    radioButton.setChecked(true);
                }
            } else {
                radioButton.setChecked(viewHolder.getAdapterPosition() == selectIndex);
            }
            viewHolder.setText(R.id.tv_item_pic_radio_title, SupplierInfoBean.SupplierContacts.getContractTitleByType(item.getType()));
            viewHolder.setImageResource(R.id.iv_item_pic_radio_pic, getContractPicByType(item.getType()));
            radioButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
                if (isChecked) {
                    setSelectIndex(viewHolder.getAdapterPosition());
                    notifyDataSetChanged();
                }
            });
        }

        public void setSelectIndex(int selectIndex) {
            this.selectIndex = selectIndex;
        }

        public int getSelectIndex() {
            return selectIndex;
        }
    }

}
