package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/22
 * Time: 14:45
 * Use:
 */
public class WareHousingDetailsAdapter extends BaseQuickAdapter<WarehouseDetailsBean.PurchaseWarehousingOrderDetailsContentsBean, BaseViewHolder> {

    public WareHousingDetailsAdapter(@Nullable List<WarehouseDetailsBean.PurchaseWarehousingOrderDetailsContentsBean> data) {
        super(R.layout.item_warehouse_details, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, WarehouseDetailsBean.PurchaseWarehousingOrderDetailsContentsBean purchaseWarehousingOrderDetailsContentsBean) {
        //食品名
        viewHolder.setText(R.id.tv_warehouse_details_food_name, purchaseWarehousingOrderDetailsContentsBean.getName());
        //入庫單位
        viewHolder.setText(R.id.tv_warehouse_details_food_unit, "單位");
        //入庫食品數量
        viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_positive), purchaseWarehousingOrderDetailsContentsBean.getFoodQuantity()));
        //下單時間
        viewHolder.setText(R.id.tv_warehouse_details_order_time, "下單時間");
        //供應商
        viewHolder.setText(R.id.tv_warehouse_details_supplier, purchaseWarehousingOrderDetailsContentsBean.getName());
        //入庫日期
        viewHolder.setText(R.id.tv_warehouse_details_time, "入庫日期");
        //入庫來源
        viewHolder.setText(R.id.tv_warehouse_details_reason, purchaseWarehousingOrderDetailsContentsBean.getPurchase());
    }
}
