package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerWarehouseDetailsComponent;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.gingersoft.supply_chain.mvp.contract.WarehouseDetailsContract;
import com.gingersoft.supply_chain.mvp.presenter.WarehouseDetailsPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchasePageAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WareHousingDetailsAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.gingersoft.supply_chain.mvp.ui.widget.InventoryConsumptionPopup;
import com.jess.arms.di.component.AppComponent;
import com.lxj.xpopup.XPopup;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import java.util.Arrays;
import java.util.List;

import butterknife.BindView;


/**
 * Description: 入庫詳情
 */
public class WarehouseDetailsFragment extends BaseSupplyChainFragment<WarehouseDetailsPresenter> implements WarehouseDetailsContract.View {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.tv_warehouse_inventory_number)
    TextView tvWarehouseInventoryNumber;
    @BindView(R2.id.tv_warehouse_specifications)
    TextView tvWarehouseSpecifications;
    @BindView(R2.id.tv_warehouse_unit_price)
    TextView tvWarehouseUnitPrice;
    @BindView(R2.id.tv_warehouse_total_amount)
    TextView tvWarehouseTotalAmount;
    @BindView(R2.id.tv_warehousing_record)
    TextView tvWarehousingRecord;
    @BindView(R2.id.tv_outbound_record)
    TextView tvOutboundRecord;
    @BindView(R2.id.vp_warehouse_viewpager)
    ViewPager2 vpWarehouseViewpager;
    @BindView(R2.id.srl_warehouse_details_list)
    SmartRefreshLayout smartRefreshLayout;

    private final static String FOOD_NAME_KEY = "foodNameKey";
    private final static String FOOD_ID_KEY = "foodIdKey";
    private final static String FOOD_UNIT_KEY = "foodUnitKey";
    private final static String FOOD_NUM_KEY = "foodNumKey";

    public static WarehouseDetailsFragment newInstance(WareHouseListBean.WareHousingDataBean.PurchaseWarehousingOrderDetailsVOSBean purchaseWarehousingOrderDetailsVosBean) {
        WarehouseDetailsFragment fragment = new WarehouseDetailsFragment();
        Bundle bundle = new Bundle();
        bundle.putString(FOOD_NAME_KEY, purchaseWarehousingOrderDetailsVosBean.getName());
        bundle.putInt(FOOD_ID_KEY, purchaseWarehousingOrderDetailsVosBean.getId());
        bundle.putString(FOOD_UNIT_KEY, purchaseWarehousingOrderDetailsVosBean.getBasicUnitName());
        bundle.putInt(FOOD_NUM_KEY, purchaseWarehousingOrderDetailsVosBean.getFoodNum());
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWarehouseDetailsComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_warehouse_details, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        smartRefreshLayout.setEnableHeaderTranslationContent(false).
                setEnableFooterTranslationContent(false);
        if (arguments != null) {
            initTopBar(supplyTopBar, arguments.getString(FOOD_NAME_KEY));
            int foodId = arguments.getInt(FOOD_ID_KEY);
            String foodUnit = arguments.getString(FOOD_UNIT_KEY);
            int foodNum = arguments.getInt(FOOD_NUM_KEY);
            mPresenter.getWarehousingOrderDetails(foodId, foodUnit);
            if (foodNum > 0) {
                //獲取庫存消耗的原因列表
                mPresenter.getWarehouseInventoryReason();
                Button button = supplyTopBar.addRightTextButton(R.string.str_inventory_consumption, R.id.id_inventory_consumption);
                button.setTextColor(ContextCompat.getColor(requireContext(), R.color.white));
                button.setOnClickListener(v -> {
                    //庫存消耗
                    new XPopup.Builder(requireContext())
                            .asCustom(new InventoryConsumptionPopup(requireContext(), Arrays.asList("正常消耗", "退貨消耗", "過期消耗", "其他消耗"), 10, (consumptionNum, reasonIndex, remarks) -> {
                            })).show();
                });
            }
            initViewPager();
        }
    }

    private void initViewPager() {
        vpWarehouseViewpager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }

            @Override
            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (position == 0) {
                    tvWarehousingRecord.setTextColor(ContextCompat.getColor(requireContext(), R.color.white));
                    tvWarehousingRecord.setBackground(ContextCompat.getDrawable(requireContext(), R.drawable.shape_left_themecolor_radius_btn));
                    tvOutboundRecord.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_3c));
                    tvOutboundRecord.setBackground(ContextCompat.getDrawable(requireContext(), R.drawable.shape_right_white_radius_btn));
                } else {
                    tvOutboundRecord.setTextColor(ContextCompat.getColor(requireContext(), R.color.white));
                    tvOutboundRecord.setBackground(ContextCompat.getDrawable(requireContext(), R.drawable.shape_left_themecolor_radius_btn));
                    tvWarehousingRecord.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_3c));
                    tvWarehousingRecord.setBackground(ContextCompat.getDrawable(requireContext(), R.drawable.shape_right_white_radius_btn));
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
                super.onPageScrollStateChanged(state);
            }
        });
    }

    private WareHousingDetailsAdapter wareHousingDetailsAdapter;

    @Override
    public void loadWarehousing(WarehouseDetailsBean warehouseDetailsBean) {
        loadAdapter(warehouseDetailsBean.getPurchaseWarehousingOrderDetailsContents());
        PurchasePageAdapter adapter = new PurchasePageAdapter(wareHousingDetailsAdapter, 2);
        vpWarehouseViewpager.setAdapter(adapter);
    }

    @Override
    public void loadAdapter(List<WarehouseDetailsBean.PurchaseWarehousingOrderDetailsContentsBean> purchaseWarehousingOrderDetailsContents) {
        if (wareHousingDetailsAdapter == null) {
            wareHousingDetailsAdapter = new WareHousingDetailsAdapter(purchaseWarehousingOrderDetailsContents);
        } else {
            wareHousingDetailsAdapter.setList(purchaseWarehousingOrderDetailsContents);
        }
    }
}
