package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerWarehousingInventoryComponent;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;
import com.gingersoft.supply_chain.mvp.contract.WarehousingInventoryContract;
import com.gingersoft.supply_chain.mvp.presenter.WarehousingInventoryPresenter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;


/**
 * Description: 庫存盤點
 */
public class WarehousingInventoryFragment extends BaseSupplyChainFragment<WarehousingInventoryPresenter> implements WarehousingInventoryContract.View {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.iv_warehouse_img)
    ImageView ivWarehouseImg;
    @BindView(R2.id.tv_warehouse_total)
    TextView tvWarehouseTotal;
    @BindView(R2.id.tv_warehouse_difference)
    TextView tvWarehouseDifference;
    @BindView(R2.id.ed_warehouse_loss)
    EditText edWarehouseLoss;

    private final static String FOOD_NAME_KEY = "foodNameKey";
    private final static String FOOD_ID_KEY = "foodIdKey";
    private final static String FOOD_NUM_KEY = "foodNumKey";

    public static WarehousingInventoryFragment newInstance(WareHouseListBean.WareHousingDataBean.PurchaseWarehousingOrderDetailsVOSBean purchaseWarehousingOrderDetailsVosBean) {
        WarehousingInventoryFragment fragment = new WarehousingInventoryFragment();
        Bundle bundle = new Bundle();
        bundle.putString(FOOD_NAME_KEY, purchaseWarehousingOrderDetailsVosBean.getName());
        bundle.putInt(FOOD_ID_KEY, purchaseWarehousingOrderDetailsVosBean.getId());
        bundle.putInt(FOOD_NUM_KEY, purchaseWarehousingOrderDetailsVosBean.getFoodNum());
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWarehousingInventoryComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_warehousing_inventory, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            int foodId = arguments.getInt(FOOD_ID_KEY);
            String foodName = arguments.getString(FOOD_NAME_KEY);
            int foodNum = arguments.getInt(FOOD_NUM_KEY);
            //初始化標題
            initTopBar(supplyTopBar, foodName);
            supplyTopBar.addRightTextButton(R.string.str_save, R.id.id_save).setOnClickListener(mOnClickListener);
            //庫存數量
            tvWarehouseTotal.setText(String.valueOf(foodNum));

        } else {
            showMessage("獲取食材信息失敗，請稍候重試");
            killMyself();
        }
    }


    private View.OnClickListener mOnClickListener = v -> {
        if(v.getId() == R.id.id_save){
            //保存
//            edWarehouseLoss.getText()
        }
    };
}
