package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.widget.EditText;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiSelectBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public class SelectItemProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {
    private Context context;

    public SelectItemProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.EDIT_FOOD_ITEM_SELECT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_multi_select;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T infoMultiBean) {
        if (infoMultiBean instanceof MultiSelectBean) {
            MultiSelectBean multiSelectBean = (MultiSelectBean) infoMultiBean;
            //是否顯示必選
            baseViewHolder.setGone(R.id.multi_required, !infoMultiBean.isRequired());
            //設置標題
            if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
                baseViewHolder.setText(R.id.tv_multi_title, infoMultiBean.getShowTitle());
            } else {
                baseViewHolder.setText(R.id.tv_multi_title, "");
            }
//            TextView textView = baseViewHolder.getView(R.id.ed_multi_value);
//
//            if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowValue())) {
//                textView.setText(infoMultiBean.getShowValue());
//            } else if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getHintText())) {
//                textView.setHint(infoMultiBean.getHintText());
//            }

            EditText edFirst = baseViewHolder.getView(R.id.ed_multi_value_first);
            initEditText(edFirst, multiSelectBean.getShowValue(), multiSelectBean.getHintText());
            if (multiSelectBean.isEdit()) {
                //可以編輯才配置這些
                KeyListener keyListener = edFirst.getKeyListener();
                edFirst.setKeyListener(keyListener);

                setFilters(edFirst, multiSelectBean);
                TextWatcher textWatcher = new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                    }

                    @Override
                    public void onTextChanged(CharSequence s, int start, int before, int count) {

                    }

                    @Override
                    public void afterTextChanged(Editable s) {
                        multiSelectBean.setShowValue(s + "");
                    }
                };
                edFirst.setOnFocusChangeListener((v, hasFocus) -> {
                    if (hasFocus) {
                        edFirst.addTextChangedListener(textWatcher);
                    } else {
                        edFirst.removeTextChangedListener(textWatcher);
                    }
                });
//                edFirst.setTextColor(getColor(R.color.color_3c));
            } else {
                edFirst.setKeyListener(null);
//                edFirst.setTextColor(getColor(R.color.color_c9));
            }
//            edFirst.setFocusableInTouchMode(multiSelectBean.isEdit());
//            edFirst.setFocusable(multiSelectBean.isEdit());
        }
    }

    private void initEditText(EditText tvThird, String showValue, String hintText) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(showValue)) {
            tvThird.setText(showValue);
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(hintText)) {
            tvThird.setHint(hintText);
        } else {
            tvThird.setText("");
        }
    }

    private void setFilters(EditText editText, MultiSelectBean multiSelectBean) {
        if (multiSelectBean.getInputFilters() != null) {
            editText.setFilters(multiSelectBean.getInputFilters());
        } else {
            editText.setFilters(editText.getFilters());
        }

        if (multiSelectBean.getInputType() != -1) {
            editText.setInputType(multiSelectBean.getInputType());
        } else {
            editText.setInputType(editText.getInputType());
        }
    }

    public int getColor(int colorId) {
        return ContextCompat.getColor(context, colorId);
    }
}
