package com.gingersoft.gsa.cloud.constans;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.BuildConfig;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;

/**
 * Created by Wyh on 2019/12/21.
 */
public class HttpsConstans {

//    public static String ROOT_ADDRESS_FORMAL = "https://m.ricepon.com:8444/ricepon-cloud-gsa/api/";//正式服務器
//    public static final String ROOT_SERVER_ADDRESS_FORMAL_SZ = "http://gingersoft.tpddns.cn:58201/ricepon-cloud-gsa/api/";//深圳服务器
//    public static final String ROOT_SERVER_ADDRESS_FORMAL_HK = "http://a.ricepon.com:58201/ricepon-cloud-gsa/api/";//香港服务器
//    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.142:9012/api/"; //友常本地
//    public static String ROOT_SERVER_SHI_WEI_HK = "http://192.168.1.154:9012/api/"; //世維本地
//    //默認為正式
//    public static String ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_ADDRESS_FORMAL_HK;
//
//    //外賣接單
//    public static final String ROOT_SZ_URL = "http://192.168.1.74:6060";//友常本地
//    public static final String ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377";//香港測試
//    public static final String ROOT_FORMAL_URL = "https://m.ricepon.com";//正式
//    public static String ROOT_URL = HttpsConstans.ROOT_HK_TEST_URL;
//
//    //清機接口地址
//    public static String ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = "http://a.ricepon.com:58201/";
//    //報表地址
//    public static String REPORT_SERVER_ADDRESS = "http://a.ricepon.com:58201/ricepon-report/api/";
//    //微信公眾號報表地址：首頁曲線圖數據，支付分析報表數據
//    public static String WECHAR_REPORT_SERVER_ADDRESS = "http://a.ricepon.com:61177/member-web/api/";
//    //報表地址
//    public static String _SERVER_ADDRESS = "http://a.ricepon.com:61177/member-web/api/";

    //--------------------------------------------其他全局----------------------------------------------------------------------------
    private static String HTTP_ADDRESS_URL_FORMAL = "https://m.ricepon.com:8444";//正式服務器
    private static String HTTP_ADDRESS_URL_SZ = "http://gingersoft.tpddns.cn:58201";//深圳測試
    private static String HTTP_ADDRESS_URL_HK = "http://a.ricepon.com:58201";//香港測試

    private static String PATH = "/ricepon-cloud-gsa/api/";//路徑

    public static String ROOT_SERVER_YOU_CHANG_HK = "http://192.168.1.142:9012/api/"; //友常本地
    public static String ROOT_SERVER_SHI_WEI_HK = "http://192.168.1.169:9012/api/"; //世維本地
    public static String ROOT_SERVER_SHI_SHU_HK = "http://192.168.1.154:9012/api/"; //石书本地

    //------------------------------------------外賣接單---------------------------------------------------------------------------
    public static final String ROOT_SZ_URL = "http://192.168.1.74:6060";//友常本地
    public static final String ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377";//香港測試
    public static final String ROOT_FORMAL_URL = "https://m.ricepon.com";//正式

    //-------------------------------------------報表-------------------------------------------------------------------------------
    private static String REPORT_TEST_ADDRESS = "http://a.ricepon.com:58201";//報表測試地址

    private static String REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//報表正式地址
    //報表路徑
    private static String REPORT_PATH = "/ricepon-report/api/";

    //----------------------------------微信公眾號報表地址------------------------------------------------------------------------------------------
    private static String WECHAR_REPORT_TEST_ADDRESS = "http://a.ricepon.com:61177";//微信公眾號報表測試地址
    private static String WECHAR_REPORT_FORMAL_ADDRESS = HTTP_ADDRESS_URL_FORMAL;//微信公眾號報表正式地址
    private static String WECHAR_REPORT_PATH = "/member-web/api/";//微信公眾號報表路徑

    //---------------------------------------System請求地址----------------------------------------------------------------------------------
    private static String SYSTEM_PATH = "/ricepon-system/api/";


    //--------------------------------------配置-----------------------------------------------------------------------------------

    /**
     * 修改這個值控制是否是正式
     * 0=正式
     * 1=香港
     * 2=友常
     * 3=世维
     * 4=石书
     */
    public static int isFormal = 0;


    //沽清控制地址
    public static String _SERVER_ADDRESS;// = (isFormal ? HTTP_ADDRESS_URL_FORMAL : "http://a.ricepon.com:61177") + "/member-web/api/";

    //清機接口地址
    public static String ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL;// = isFormal ? HTTP_ADDRESS_URL_FORMAL : REPORT_TEST_ADDRESS;

    //默認url，配置這個值修改環境
    public static String ROOT_SERVER_ADDRESS_FORMAL = (isFormal == 1 ? HTTP_ADDRESS_URL_FORMAL : HTTP_ADDRESS_URL_HK) + PATH;

    //修改這個值，配置外賣接單環境
    public static String ROOT_URL;// = isFormal ? ROOT_FORMAL_URL : ROOT_HK_TEST_URL;//正式：ROOT_FORMAL_URL   測試：ROOT_HK_TEST_URL

    //修改這個值，修改報表默認環境
    public static String REPORT_SERVER_ADDRESS;// = (isFormal ? REPORT_FORMAL_ADDRESS : REPORT_TEST_ADDRESS) + REPORT_PATH;//測試：REPORT_FORMAL_ADDRESS 正式：REPORT_TEST_ADDRESS

    //修改這個值，修改微信公眾號報表地址：首頁曲線圖數據，支付分析報表數據
    public static String WECHAR_REPORT_SERVER_ADDRESS;// = (isFormal ? WECHAR_REPORT_FORMAL_ADDRESS : WECHAR_REPORT_TEST_ADDRESS) + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS

    public static String SYSTEM_URL;

    public static void init(Context context) {
        isFormal = (int) SPUtils.get(context, "isFormal", -1);
        if (isFormal == -1 && BuildConfig.DEBUG) {
            //如果沒有手動配置過服務器，並且是DEBUG模式，默認是測試服務器
            isFormal = 1;
        } else if (isFormal == -1) {
            isFormal = 0;
        }
        switch (isFormal) {
            default:
                _SERVER_ADDRESS = HTTP_ADDRESS_URL_FORMAL + "/member-web/api/";
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL;
                ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_FORMAL + PATH;
                ROOT_URL = ROOT_FORMAL_URL;
                REPORT_SERVER_ADDRESS = REPORT_FORMAL_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_FORMAL_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = HTTP_ADDRESS_URL_FORMAL + SYSTEM_PATH;
                break;
            case 1:
                _SERVER_ADDRESS = "http://a.ricepon.com:61177" + "/member-web/api/";
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = HTTP_ADDRESS_URL_HK + PATH;
                ROOT_URL = ROOT_HK_TEST_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_HK_TEST_URL + SYSTEM_PATH;
                break;
            case 2:
                _SERVER_ADDRESS = ROOT_SERVER_YOU_CHANG_HK + "/member-web/api/";
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_YOU_CHANG_HK;
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_SERVER_YOU_CHANG_HK + SYSTEM_PATH;
                break;
            case 3:
                _SERVER_ADDRESS = ROOT_SERVER_SHI_WEI_HK + "/member-web/api/";
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_SHI_WEI_HK;
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_SERVER_SHI_WEI_HK + SYSTEM_PATH;
                break;
            case 4:
                _SERVER_ADDRESS = ROOT_SERVER_SHI_SHU_HK + "/member-web/api/";
                ROOT_SETTLEMENT_REPORT_SERVER_ADDRESS_FORMAL = REPORT_TEST_ADDRESS;
                ROOT_SERVER_ADDRESS_FORMAL = ROOT_SERVER_SHI_SHU_HK;
                ROOT_URL = ROOT_SZ_URL;
                REPORT_SERVER_ADDRESS = REPORT_TEST_ADDRESS + REPORT_PATH;
                WECHAR_REPORT_SERVER_ADDRESS = WECHAR_REPORT_TEST_ADDRESS + WECHAR_REPORT_PATH;//正式：WECHAR_REPORT_FORMAL_ADDRESS 測試：WECHAR_REPORT_TEST_ADDRESS
                SYSTEM_URL = ROOT_SERVER_SHI_SHU_HK + SYSTEM_PATH;
                break;
        }

    }

}