package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.FoodModifier;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD_MODIFIER".
*/
public class FoodModifierDao extends AbstractDao<FoodModifier, Long> {

    public static final String TABLENAME = "FOOD_MODIFIER";

    /**
     * Properties of entity FoodModifier.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Id = new Property(1, Long.class, "id", false, "ID");
        public final static Property Fid = new Property(2, Long.class, "fid", false, "FID");
        public final static Property Mid = new Property(3, Long.class, "mid", false, "MID");
    }

    private DaoSession daoSession;


    public FoodModifierDao(DaoConfig config) {
        super(config);
    }
    
    public FoodModifierDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD_MODIFIER\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"ID\" INTEGER NOT NULL ," + // 1: id
                "\"FID\" INTEGER," + // 2: fid
                "\"MID\" INTEGER);"); // 3: mid
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD_MODIFIER\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, FoodModifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
 
        Long mid = entity.getMid();
        if (mid != null) {
            stmt.bindLong(4, mid);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, FoodModifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
 
        Long mid = entity.getMid();
        if (mid != null) {
            stmt.bindLong(4, mid);
        }
    }

    @Override
    protected final void attachEntity(FoodModifier entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public FoodModifier readEntity(Cursor cursor, int offset) {
        FoodModifier entity = new FoodModifier( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.getLong(offset + 1), // id
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // fid
            cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3) // mid
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, FoodModifier entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setId(cursor.getLong(offset + 1));
        entity.setFid(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setMid(cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(FoodModifier entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(FoodModifier entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(FoodModifier entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
