package com.gingersoft.gsa.cloud.download;

import android.content.Context;
import android.text.TextUtils;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.IComponent;
import com.gingersoft.gsa.cloud.base.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.download.mvp.ui.activity.DownloadActivity;

import java.util.List;


public class ComponentDownload implements IComponent {


    @Override
    public String getName() {
        //组件的名称，调用此组件的方式：
        // CC.obtainBuilder("ComponentA")...build().callAsync()
        return "Component.Download";
    }

    /**
     * 组件被调用时的入口
     * 要确保每个逻辑分支都会调用到CC.sendCCResult，
     * 包括try-catch,if-else,switch-case-default,startActivity
     *
     * @param cc 组件调用对象，可从此对象中获取相关信息
     * @return true:将异步调用CC.sendCCResult(...),用于异步实现相关功能，例如：文件加载、网络请求等
     * false:会同步调用CC.sendCCResult(...),即在onCall方法return之前调用，否则将被视为不合法的实现
     */
    @Override
    public boolean onCall(CC cc) {
        String actionName = cc.getActionName();
        Context context = cc.getContext();
        switch (actionName) {
            case "showDownloadActivity":
                openActivity(cc);
                break;
            case "getFunctionlist":
                //demo for provide fragment object to other component
                getFunctionlist(cc);
                break;
            case "getFoodGroupList":
                getFoodGroupList(cc);
                break;
            case "getFoodListByParentId":
                getFoodListByParentId(cc);
                break;
            case "getInfo":
                getInfo(cc);
                break;
            default:
                //这个逻辑分支上没有调用CC.sendCCResult(...),是一种错误的示例
                //并且方法的返回值为false，代表不会异步调用CC.sendCCResult(...)
                //在LocalCCInterceptor中将会返回错误码为-10的CCResult
                break;
        }
        return false;
    }

    private void getFunctionlist(CC cc) {

        String parentId = cc.getParamItem("parentId");

        if (TextUtils.isEmpty(parentId)) {

        } else {

        }
    }

    private void getFoodGroupList(CC cc) {
        List<Food> foodGroupList = queryDB_FoodGroupList(cc.getContext());
        if (foodGroupList != null) {
            CCResult ccResult = CCResult.success("foodGroupList", GsonUtils.GsonString(foodGroupList));
            CC.sendCCResult(cc.getCallId(), ccResult);
        } else {
            CC.sendCCResult(cc.getCallId(), CCResult.error("foodGroupList is null"));
        }
    }

    private void getFoodListByParentId(CC cc) {
        int parentId = cc.getParamItem("parentId");
        List<Food> foodList = queryDB_FoodList(cc.getContext(), parentId);
        if (foodList != null) {
            CC.sendCCResult(cc.getCallId(), CCResult.success("foodList", GsonUtils.GsonString(foodList)));
        } else {
            CC.sendCCResult(cc.getCallId(), CCResult.error("foodList is null"));
        }
    }

    public List<Food> queryDB_FoodGroupList(Context context) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(context);
        return foodDaoUtils.queryFoodGroupByQueryBuilder();
    }

    public List<Food> queryDB_FoodList(Context context, int parentId) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(context);
        return foodDaoUtils.queryFoodByQueryBuilder(parentId);
    }

    private void getInfo(CC cc) {
        String userName = "billy";
        CC.sendCCResult(cc.getCallId(), CCResult.success("userName", userName));
    }

    private void openActivity(CC cc) {
        CCUtil.navigateTo(cc, DownloadActivity.class);
        CC.sendCCResult(cc.getCallId(), CCResult.success());
    }

}
