package com.joe.print.mvp.print;

import android.content.Context;
import android.os.RemoteException;
import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.hyweb.n5.lib.util.PrinterUtil;
import com.jess.arms.utils.ArmsUtils;
import com.sunmi.peripheral.printer.SunmiPrinterService;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/6/27
 * 修订历史：2019/6/27
 * 描述：
 */
public class PrintStatus {

    public static boolean initV2PrintStatus(Context context, SunmiPrinterService service) {
        int printerState = 0;
        try {
            printerState = service.updatePrinterState();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        switch (printerState) {
            case 1://打印机?作正常
                return true;
            case 2://打印机准备中
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.prepare", "打印機準備中"));
                break;
            case 3://通讯异常
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "printer.abnormal.communication", "打印機通訊異常"));
                break;
            case 4://缺纸
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.out.of.paper", "打印機缺紙"));
                break;
            case 5://过热
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.overheat", "打印機過熱"));
                break;
            case 6://开盖
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.open.cover", "打印機開蓋"));
                break;
            case 7://切?异常
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.cutter.abnormality", "打印機切刀異常"));
                break;
            case 8://切?恢复
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.cutter.recovery", "打印機切刀恢復"));
                break;
            case 9://未检测到?标
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.not.black.mark", "打印機未檢測到黑標"));
                break;
            case 505://未检测到打印机
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.not.detected", "未檢測到打印機"));
                break;
            case 507://打印机固件升级失败
                ArmsUtils.makeText(context, LanguageUtils.get_language_system(context, "print.fixed.upgrade.failed", "打印機固定升級失敗"));
                break;
        }
        return false;
    }


    public static boolean initN5PrintStatus(Context context) {
        try {
            int status = PrinterUtil.getStatus();
            switch (status) {
                case 0: //可以打印
//                    N5PrintCallback printCallBack = new N5PrintCallback(context);
//                    PrinterUtil.registerCallback(printCallBack);
                    return true;
                case -1009: //打印未完成
                    String notCompleted = LanguageUtils.get_language_system(context, "print.not.completed", "打印未完成");
                    ArmsUtils.makeText(context, notCompleted);
                    break;
                case -1005: //打印机缺纸
                    String noPaper = LanguageUtils.get_language_system(context, "printer.no.paper", "打印机缺纸");
                    ArmsUtils.makeText(context, noPaper);
                    break;
                case -1008: //打印机过热
                    String printerOverheated = LanguageUtils.get_language_system(context, "printer.overheated", "打印机过热");
                    ArmsUtils.makeText(context, printerOverheated);
                    break;
                case -1001: //  打印失败
                    String printFailed = LanguageUtils.get_language_system(context, "print.failed", "打印失敗");
                    ArmsUtils.makeText(context, printFailed);
                    break;
                case -1: //其他错误
                    ArmsUtils.makeText(context, "other error");
                    break;
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

}
