package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use: 一級分類
 */
public class FirstLevelCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectedIndex = 0;
    private int selectedBg = R.drawable.shape_left_radio_shadow;
    private int unSelectedBg = R.color.trans;

    private int selectColor = -1;
    private int unSelectColor = -1;
    /**
     * 一級分類是否顯示此分類已選食材數量
     */
    private boolean showNumber = true;

    public FirstLevelCategoryAdapter(@Nullable List<OrderCategoryBean.FoodCategoryTrees> data, Context context) {
        super(R.layout.item_first_level_category, data);
        selectColor = ContextCompat.getColor(context, R.color.other_order_details_sure_btn_color);
        unSelectColor = ContextCompat.getColor(context, R.color.color_3c);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees categoryBean) {
        TextView tvCategoryName = viewHolder.getView(R.id.tv_category_name);
        tvCategoryName.setText(categoryBean.getName());
        CardView view = viewHolder.getView(R.id.layout_category);
        if (categoryBean.getSize() > 0 && showNumber) {
            viewHolder.setText(R.id.tv_category_number, String.valueOf(categoryBean.getSize()));
            viewHolder.setGone(R.id.tv_category_number, false);
        } else {
            viewHolder.setGone(R.id.tv_category_number, true);
        }
        //選中時的背景和文字顏色
        if (viewHolder.getAdapterPosition() == selectedIndex) {
            view.setBackground(ContextCompat.getDrawable(getContext(), selectedBg));
            if (selectColor != -1) {
                tvCategoryName.setTextColor(selectColor);
            }
            tvCategoryName.setSelected(true);
        } else {
            tvCategoryName.setSelected(false);
            view.setBackground(ContextCompat.getDrawable(getContext(), unSelectedBg));
            if (unSelectColor != -1) {
                tvCategoryName.setTextColor(unSelectColor);
            }
        }
    }

    @Override
    protected void convert(@NotNull BaseViewHolder holder, OrderCategoryBean.FoodCategoryTrees item, @NotNull List<?> payloads) {
        if (payloads.isEmpty()) {
            convert(holder, item);
        } else {
            if (item.getSize() > 0) {
                holder.setText(R.id.tv_category_number, String.valueOf(item.getSize()));
                holder.setGone(R.id.tv_category_number, false);
            } else {
                holder.setGone(R.id.tv_category_number, true);
            }
        }
    }

    public FirstLevelCategoryAdapter setIsShowNumber(boolean showNumber) {
        this.showNumber = showNumber;
        return this;
    }

    public FirstLevelCategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public FirstLevelCategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
