package com.gingersoft.gsa.cloud.common.oaId.defaultImp;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.utils.FileUtils;

/**
 * @作者: bin
 * @創建時間: 2020-12-25 15:01
 * @更新時間: 2020-12-25 15:01
 * @描述: 方案2：usd + "_" + UUID + SD卡（存取）
 */
public class SDDeviceId {

    /**
     * 方案2：UUID + SD卡（存取）
     * APP首次使用时，创建UUID，并保存到SD卡中。
     * 以后再次使用时，直接从SD卡取出来即可；
     * 很多APP就是这么做的；
     * <p>
     * 优点：数据唯一、不随APP一起删除；
     * 缺点：需要SD卡读写权限；防不住用户手动删除SD卡的文件；
     */
    private static final String scheme_2 = "usd";

    /**
     * 存放deviceId的文件
     */
    private static String DEVICE_ID_FILE_NAME = "systemDeviceId.txt";


    public static String getSDDeviceId(String defaultDeviceId) {
        //讀取設備ID
        String deviceId = FileUtils.read(GsaCloudApplication.getAppContext(), "systemDeviceId.txt");
        if (TextUtils.isEmpty(deviceId)) {
            defaultDeviceId = scheme_2 + "_" + defaultDeviceId;
            //寫入設備ID
            FileUtils.write(GsaCloudApplication.getAppContext(), "systemDeviceId.txt", defaultDeviceId);
            deviceId = defaultDeviceId;
        }
        return deviceId;
    }

}
