package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;

import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.constant.MealConstant;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.MealStandActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.FineItemOneAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.FineItemTwoAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.ChooseNumberDialog;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemKindContract;

import org.simple.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FineItemKindPresenter extends BasePresenter<FineItemKindContract.Model, FineItemKindContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private FineItemOneAdapter mFineItemOneAdapter;
    private FineItemTwoAdapter mFineItemTwoAdapter;

    //所有沽清数据
//    private List<CurrentSoldoutFood.DatasBean> mCurrentSlodoutFoodList_Full = null;

    private List<Modifier> mFineItemOneList = new ArrayList<>();
    private List<Modifier> mFineItemTwoList = new ArrayList<>();

    //记录第一层细项上次选中的食品种类
    private int mFineItemOneLastPosition = -1;
    //记录第二层细项上次选中的食品种类
    private int mFineItemTwoLastPosition = -1;

    //操作頁面：1=沽清頁、2=餐牌頁
    private int operartPage = 1;

    private Activity IActivity;

    @Inject
    public FineItemKindPresenter(FineItemKindContract.Model model, FineItemKindContract.View rootView) {
        super(model, rootView);
        this.IActivity = (Activity) rootView.getCurrentActivity();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
        destroyRecler();
    }

    public void initAdapter() {
        if (mFineItemOneAdapter == null) {
            mFineItemOneAdapter = new FineItemOneAdapter(mApplication, mFineItemOneList);
            mRootView.setFineItemKindAdapter(mFineItemOneAdapter);
        }
        if (mFineItemTwoAdapter == null) {
            mFineItemTwoAdapter = new FineItemTwoAdapter(mApplication, mFineItemTwoList);
            mRootView.setFineItemKindItemAdapter(mFineItemTwoAdapter);
        }
    }

    public void initItemListener(Context context) {
        mFineItemOneAdapter.setOnItemClickListener(new FineItemOneAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(Modifier datasBean, int position) {

                VibratorUtils.pressButtonSound(mApplication);

                if (context instanceof MealStandActivity) {

                    operartPage = 2;

                    MealStandActivity mealStandActivity = (MealStandActivity) context;

                    //有子细项
                    if (datasBean.isParent()) {
//                        if (datasBean.isModKeyboard()) {
//                            //获取细项备注数据，这里为了拿到最大最小数
////                            List<Modifier> modifierList = mealStandActivity.getMealStandModel().queryDB_ComboSelfDetailList(datasBean.getFid(), MealStandModel.modifierMode_Add);
////                            for (int i = 0; i < modifierList.size(); i++) {
////                                String fid1 = modifierList.get(i).getFid();
////                                String fid2 = datasBean.getFid();
////                                if (fid1.equals(fid2)) {
//                            mealStandActivity.getMealStandPresenter().addModalKeyBoardModfier(datasBean);
//                            mealStandActivity.getMealStandPresenter().displayModalKeyBoardDialog();
////                                    break;
////                                }
////                            }
//                        } else {
                        initFineItemKindItemData(datasBean.getMid());
//                        }
                    } else {
                        addModifierItem(datasBean);
                    }
                } else {
                    operartPage = 1;
                    soldoutCtrlModifierItem(context, datasBean);
                }
            }
        });
        mFineItemTwoAdapter.setOnItemClickListener(new FineItemTwoAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(Modifier datasBean, int position) {

                VibratorUtils.pressButtonSound(mApplication);

                if (operartPage == 2) {
                    addModifierItem(datasBean);
                } else {
                    soldoutOpeart(context, datasBean);
                }
            }

            @Override
            public void onClickReturnFineItemOne() {
                mRootView.getRecycle_fine_item_kind_item().setVisibility(View.INVISIBLE);
                mRootView.getRecycle_fine_item_kind().setVisibility(View.VISIBLE);
            }
        });
    }

    private void soldoutCtrlModifierItem(Context context, Modifier datasBean) {
        //有子细项
        if (datasBean.isParent()) {
            initFineItemKindItemData(datasBean.getMid());
        } else {
            soldoutOpeart(context, datasBean);
        }
    }

    private void addModifierItem(Modifier datasBean) {

        int OR_Qty = datasBean.getMaxNumber();
        int Qty = datasBean.getNumber();
        boolean isSoldout = false;

//        if (datasBean.isSoldout() || OR_Qty.equalsIgnoreCase("售罄") || OR_Qty.equalsIgnoreCase("暫停")) {
//            isSoldout = true;
//        } else if (!TextUtils.isEmpty(OR_Qty)) {
//            isSoldout = Integer.parseInt(OR_Qty) <= Qty;
//        }

//        if (isSoldout) {
//            String Showtile = LanguageUtils.get_language_system(mApplication, "meal.Qty.short", "%s數量不足(meal.Qty.short)");
//            Showtile = Showtile.format(Showtile, AndroidSettingUtils.getDataLanguage(datasBean.getDesc1(), datasBean.getDesc2(), datasBean.getDesc3()));
//            TitleDialog.showTitledialog(IActivity, Showtile,
//                    LanguageUtils.get_language_system(mApplication, "comm.title", "qmui_icon_dialog_surprised"),
//                    LanguageUtils.get_language_system(mApplication, "comm.BtnOk", "ok"),
//                    "", null);
//        } else {
        EventBus.getDefault().post(datasBean, MealConstant.ADD_FOOD_MODIFIER);
//        }
    }

    private void soldoutOpeart(Context context, Modifier datasBean) {
        //操作類型(暂停操作、恢复操作)
        if (!isStopOpeart(datasBean)) {
            //选择沽清的数量
            ChooseNumberDialog inputNumberDialog = new ChooseNumberDialog(context);
            inputNumberDialog.builder();
            inputNumberDialog.setOnClickListener(new ChooseNumberDialog.OnClickListener() {
                @Override
                public void onComfirmClick(String number) {
//                    EventBus.getDefault().post(new InsertSoldoutCtrlEvent(datasBean.getMID(), number), "InsertSoldoutCtrlEvent");
                }

                @Override
                public void onBackPage() {

                }
            });
            inputNumberDialog.setType(2);
            inputNumberDialog.setCancelable(true);
            inputNumberDialog.show();
        }
    }

    private boolean isStopOpeart(Modifier datasBean) {
        boolean isStopOpeart = false;
//        if (mCurrentSlodoutFoodList_Full != null && mCurrentSlodoutFoodList_Full.size() > 0) {
//            for (CurrentSoldoutFood.DatasBean csf : mCurrentSlodoutFoodList_Full) {
//                if (csf.getItemID().equals(datasBean.getMID()) && csf.getType().equals("M")) {
//                    if (!TextUtils.isEmpty(csf.get_QtyName())) {
//                        isStopOpeart = true;
//                        //暂停或者售罄直接提示恢复
//                        EventBus.getDefault().post(csf, "toRestoreBeforeEvent");
//                    }
//                }
//            }
//        }
        return isStopOpeart;
    }

    public void initFineItemKindData(long fid) {

        mFineItemOneLastPosition = -1;

        //获取数据
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByModModTasteVisibleQueryBuilder(1, 0);

        if (modifierList == null || modifierList.size() == 0) {
            mFineItemOneList.clear();
            mFineItemOneAdapter.notifyDataSetChanged();
            return;
        }

        setFid(modifierList, fid);

        mFineItemOneList.clear();
        mFineItemOneList.addAll(modifierList);
        mRootView.setFineItemKindRecycleSpanCount(mFineItemOneList.size());
        mFineItemOneAdapter.notifyDataSetChanged();
    }


    public void initFineItemKindItemData(long fid) {

        mFineItemTwoLastPosition = -1;

        //获取数据
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByTopidAndVisibleQueryBuilder(fid);

        if (modifierList == null || modifierList.size() == 0) {
            return;
        }

        setFid(modifierList, fid);

        //添加返回按鈕
        Modifier datasBean = new Modifier();
        datasBean.setModifierName("返回");
        datasBean.setReturn(true);
        datasBean.setBgColor(android.graphics.Color.parseColor("#FFFF0000"));

        modifierList.add(0, datasBean);

        mFineItemTwoList.clear();
        mFineItemTwoList.addAll(modifierList);
        mRootView.setFineItemKindItemRecycleSpanCount(mFineItemTwoList.size());
        mFineItemTwoAdapter.notifyDataSetChanged();

        mRootView.getRecycle_fine_item_kind_item().setVisibility(View.VISIBLE);
        mRootView.getRecycle_fine_item_kind().setVisibility(View.INVISIBLE);
    }

    private void setFid(List<Modifier> fineItemList, long fid) {
        if (fineItemList == null)
            return;
        for (int i = 0; i < fineItemList.size(); i++) {
            Modifier modifier = fineItemList.get(i);
            modifier.setFid(fid);
        }
    }
//    public void updateCurrentSlodoutFoodList_Full1(List<CurrentSoldoutFood.DatasBean> event) {
//        this.mCurrentSlodoutFoodList_Full = event;
//        mFineItemOneAdapter.setmCurrentSlodoutFoodList_Full(event);
//        mFineItemOneAdapter.notifyDataSetChanged();
//    }
//
//    public void updateCurrentSlodoutFoodList_Full2(List<CurrentSoldoutFood.DatasBean> event) {
//        mFineItemTwoAdapter.setmCurrentSlodoutFoodList_Full(event);
//        mFineItemTwoAdapter.notifyDataSetChanged();
//    }

    public void changeLanguageNotifyChanged() {
        mFineItemOneAdapter.notifyDataSetChanged();
        mFineItemTwoAdapter.notifyDataSetChanged();
    }

    private void destroyRecler() {
        if (mFineItemOneAdapter != null) {
            mFineItemOneAdapter = null;
        }
        if (mFineItemTwoAdapter != null) {
            mFineItemTwoAdapter = null;
        }
//        if (mCurrentSlodoutFoodList_Full != null) {
//            mCurrentSlodoutFoodList_Full.clear();
//            mCurrentSlodoutFoodList_Full = null;
//        }
        if (mFineItemOneList != null) {
            mFineItemOneList.clear();
            mFineItemOneList = null;
        }
        if (mFineItemTwoList != null) {
            mFineItemTwoList.clear();
            mFineItemTwoList = null;
        }
    }
}
