package com.gingersoft.gsa.cloud.manager.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.constans.MealConstant;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableArea;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableItem;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.request.AreaRequest;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.request.TableRequest;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AddAreaFragment;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AddTableFragment;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AreaListFragment;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.TableListFragment;
import com.gingersoft.gsa.cloud.ui.utils.AnimateUtils;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.manager.di.component.DaggerTableManageComponent;
import com.gingersoft.gsa.cloud.manager.mvp.contract.TableManageContract;
import com.gingersoft.gsa.cloud.manager.mvp.presenter.TableManagePresenter;

import com.gingersoft.gsa.cloud.manager.R;
import com.jess.arms.utils.RxLifecycleUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;


import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import butterknife.BindView;
import butterknife.OnClick;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.anim.DefaultHorizontalAnimator;
import me.yokeyword.fragmentation.anim.FragmentAnimator;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/13/2020 14:47
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class TableManageActivity extends BaseFragmentActivity<TableManagePresenter> implements TableManageContract.View {

    public static final int ADD_TABLE_RESULT_SUCCESS = 100;
    public static final int ADD_AREA_RESULT_SUCCESS = 200;

    public static final int ADD_AREA_SUCCESS = 10;
    public static final int DELETE_AREA_SUCCESS = 11;
    public static final int UPDATE_AREA_SUCCESS = 12;
    public static final int QUERY_AREA_SUCCESS = 13;

    public static final byte ADD_TABLE_SUCCESS = 20;
    public static final byte DELETE_TABLE_SUCCESS = 21;
    public static final byte UPDATE_TABLE_SUCCESS = 22;
    public static final byte QUERY_TABLE_SUCCESS = 23;

    private List<TableArea> mTableAreaList = new ArrayList<>();

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerTableManageComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_table_manage; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        if (findFragment(TableListFragment.class) == null) {
            loadRootFragment(R.id.fl_container, TableListFragment.newInstance());
        }
    }

    @Override
    public void onBackPressedSupport() {
        // 对于 4个类别的主Fragment内的回退back逻辑,已经在其onBackPressedSupport里各自处理了
        super.onBackPressedSupport();
    }

    @Override
    public FragmentAnimator onCreateFragmentAnimator() {
        // 设置横向(和安卓4.x动画相同)
        return new DefaultHorizontalAnimator();
    }

    public void addArea(AreaRequest.Add request) {
        mPresenter.addArea(request);
    }

    public void deleteArea(String ids) {
        mPresenter.deleteArea(ids);
    }

    public void updateArea(AreaRequest.Update request) {
        mPresenter.updateArea(request);
    }

    public void queryAreas(RefreshLayout refreshLayout) {
        mPresenter.queryAreas(refreshLayout);
    }

    public void addTable(TableRequest.Add request) {
        mPresenter.addTable(request);
    }

    public void deleteTable(String ids) {
        mPresenter.deleteTable(ids);
    }

    public void updateTable(TableRequest.Add request) {
        mPresenter.updateTable(request);
    }

    public void queryTables(RefreshLayout refreshLayout) {
        mPresenter.queryTables(refreshLayout);
    }


    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void queryAreasSuccess(List<TableArea> areas, int type) {
        if (mTableAreaList.size() > 0) {
            mTableAreaList.clear();
        }
        this.mTableAreaList.addAll(areas);

        ISupportFragment fragment = getTopFragment();
        if (fragment != null) {
            if (fragment instanceof AreaListFragment) {
                AreaListFragment areaListFragment = (AreaListFragment) fragment;
                areaListFragment.updateAreaData(areas);
            } else if (fragment instanceof TableListFragment) {
                TableListFragment tableListFragment = (TableListFragment) fragment;
                tableListFragment.updateAreaData(areas);
            }
            switch (type) {
                case ADD_AREA_SUCCESS:
                case UPDATE_AREA_SUCCESS:
                    AddAreaFragment addAreaFragment = (AddAreaFragment) fragment;
                    addAreaFragment.pop();
                    AreaListFragment areaListFragment = findFragment(AreaListFragment.class);
                    if (areaListFragment != null) {
                        areaListFragment.updateAreaData(areas);
                    }
                    break;
                case DELETE_AREA_SUCCESS:

                    break;
                case QUERY_AREA_SUCCESS:

                    break;
            }
        }
    }

    @Override
    public void queryTablesSuccess(List<TableItem> tables, int type) {
        ISupportFragment fragment = getTopFragment();
        if (fragment != null) {
            fragment = getTopFragment();
            TableListFragment tableListFragment = (TableListFragment) fragment;
            tableListFragment.updateTableData(tables);
            switch (type) {
                case ADD_TABLE_SUCCESS:
                case UPDATE_TABLE_SUCCESS:
                    AddTableFragment addTableFragment = (AddTableFragment) fragment;
                    addTableFragment.pop();
                    tableListFragment = findFragment(TableListFragment.class);
                    if (tableListFragment != null) {
                        tableListFragment.updateTableData(tables);
                    }
                    break;
                case DELETE_TABLE_SUCCESS:

                    break;
                case QUERY_TABLE_SUCCESS:

                    break;
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ADD_TABLE_RESULT_SUCCESS && resultCode == 200) {
            //更新餐檯列表數據

        } else if (requestCode == ADD_AREA_RESULT_SUCCESS && resultCode == 200) {
            //更新區域數據

        }
    }


    public List<TableArea> getTableAreaList() {
        return mTableAreaList;
    }
}
