package com.gingersoft.gsa.cloud.download.mvp.contract;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ComboItemRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodComboRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodModifierRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FunctionRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ModifierRespone;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;

import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 17:59
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface DownloadContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        RecyclerView getRecycleDownload();

        void setDownLoadListAdapter(DefaultAdapter adapter);

    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        List<Food> queryDB_FoodGroupList(Context context);

        List<Food> queryDB_FoodList(Context context, int parentId);

        Observable<FunctionRespone> downFunctionList();

        Observable<FoodBean> downFoodList(int restaurantId);

        Observable<ModifierRespone> downModifier(int restaurantId);

        Observable<FoodComboRespone> downFoodCombo(int restaurantId);

        Observable<ComboItemRespone> downComboItem(int restaurantId);

        Observable<FoodModifierRespone> downFoodModifier(int restaurantId);

        Observable<BaseResult> downDiscount(int restaurantId);

        Observable<BaseResult> downExpandInfo(int restaurantId);

        Observable<BaseResult> downPrinterList(int restaurantId);
    }
}
