package com.gingersoft.gsa.cloud.manager.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableArea;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableItem;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.manager.mvp.contract.TableListContract;
import com.qmuiteam.qmui.widget.section.QMUISection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/20/2020 10:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class TableListPresenter extends BasePresenter<TableListContract.Model, TableListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public TableListPresenter(TableListContract.Model model, TableListContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    /**
     * 組合餐檯區域集合
     */
    public List<TableArea> assembleTableArea(List<TableArea> areaList, List<TableItem> tableList) {

        List<TableArea> tableAreaList = new ArrayList<>();

        if (areaList.size() == 0) {
            TableArea area = new TableArea();
            area.setId(-1);
            area.setRegionName("其他");
            areaList.add(area);
        }

        for (TableArea area : areaList) {
            TableArea newArea = new TableArea(area);
            List<TableItem> tableItemList = new ArrayList<>();
            for (TableItem table : tableList) {
                if (table.getRegionId() == area.getId()) {
                    tableItemList.add(table);
                }
            }
            newArea.setTableItemList(tableItemList);
            tableAreaList.add(newArea);
        }
        return tableAreaList;
    }

    /**
     * 組合區域集合
     */
    public List<TableArea> assembleAreaList(List<TableItem> tableList) {
        List<TableArea> areaList = new ArrayList<>();
        for (TableItem table : tableList) {
            if (table.getRegionId() != 0 && !equalsAreaId(areaList, table.getRegionId())) {
                TableArea newArea = new TableArea();
                newArea.setId(table.getRegionId());
                newArea.setRegionName("大廳");
                areaList.add(newArea);
            }
        }
        return areaList;
    }

    public boolean equalsAreaId(List<TableArea> areaList, int id) {
        for (TableArea area : areaList) {
            if (area.getId() == id) {
                return true;
            }
        }
        return false;
    }

    public List<QMUISection<SectionHeader, TableItem>> tableAreaTransformToSection(List<TableArea> mItems) {
        List<QMUISection<SectionHeader, TableItem>> qmuiSections = new ArrayList<>();
        for (int i = 0; i < mItems.size(); i++) {
            TableArea tableArea = mItems.get(i);
            qmuiSections.add(createSection(tableArea));
        }
        return qmuiSections;
    }

    private QMUISection<SectionHeader, TableItem> createSection(TableArea tableArea) {
        SectionHeader header = new SectionHeader(tableArea.getRegionName());
        ArrayList<TableItem> contents = new ArrayList<>();
        if (Objects.requireNonNull(tableArea.getTableItemList().size()) > 0) {
            contents.addAll(tableArea.getTableItemList());
        }
        return new QMUISection(header, contents, false);
    }
}
