package com.gingersoft.gsa.cloud.manager.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.manager.R;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableArea;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：餐檯管理列表
 */

public class AreaManageAdapter extends DefaultAdapter<TableArea> {

    private Context mContext;
    private boolean isRadioEdit;

    public AreaManageAdapter(Context context, List<TableArea> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<TableArea> getHolder(View v, int viewType) {
        return new TopTableAreaItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.manager_item_manage_area;
    }

    class TopTableAreaItemHolder extends BaseHolder<TableArea> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
//        @BindView(R2.id.tv_edit)
//        TextView tv_edit;
        @BindView(R2.id.cb_checked)
        CheckBox cb_checked;

        public TopTableAreaItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(TableArea datasBean, int position) {
            tv_name.setText(datasBean.getRegionName());
//            tv_edit.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    if (onClickListener != null)
//                        onClickListener.onItemClick(v, datasBean);
//                }
//            });
            if (isRadioEdit) {
                cb_checked.setChecked(datasBean.isChecked());
                cb_checked.setVisibility(View.VISIBLE);
                cb_checked.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        datasBean.setChecked(isChecked);
                    }
                });
            } else {
                cb_checked.setVisibility(View.GONE);
            }
        }
    }

    public void setRadioEdit(boolean radioEdit) {
        isRadioEdit = radioEdit;
    }

    private OnClickListener onClickListener;

    public void setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public interface OnClickListener {

        void onItemClick(View v, TableArea function);

    }
}
