package com.gingersoft.gsa.cloud.manager.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.manager.R;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.TableItem;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.view.qm.QDLoadingItemView;
import com.gingersoft.gsa.cloud.ui.view.section.QDSectionHeaderView;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import androidx.annotation.NonNull;
import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-09
 * 修订历史：2020-02-09
 * 描述：
 */
public class TableManageSectiontAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, TableItem> {

    private Context context;
    private boolean isRadioEdit = false;

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        return new QMUIStickySectionAdapter.ViewHolder(new QDSectionHeaderView(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.manager_item_manage_table, null));
    }

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionLoadingViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new QDLoadingItemView(viewGroup.getContext()));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableItem> section) {
        super.onBindSectionHeader(holder, position, section);
        QDSectionHeaderView itemView = (QDSectionHeaderView) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
//        itemView.setBackgroundColor(ContextCompat.getColor(context,R.color.theme_background_color));
        itemView.getArrowView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = holder.isForStickyHeader ? position : holder.getAdapterPosition();
                toggleFold(pos, false);
            }
        });
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;

        TableItem tableItem = section.getItemAt(itemIndex);

        viewHolder.tv_name.setText(tableItem.getTableName());
        if (tableItem.getServiceCharge() > 0) {
            viewHolder.tv_service_fee.setText("$" + tableItem.getServiceCharge());
            viewHolder.tv_service_fee.setVisibility(View.VISIBLE);
        } else {
            viewHolder.tv_service_fee.setVisibility(View.INVISIBLE);
        }
        if (isRadioEdit) {
            viewHolder.cb_checked.setChecked(tableItem.isChecked());
            viewHolder.cb_checked.setVisibility(View.VISIBLE);
            viewHolder.cb_checked.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    tableItem.setChecked(isChecked);
                }
            });
        } else {
            viewHolder.cb_checked.setVisibility(View.GONE);
        }
    }

    public void setRadioEdit(boolean radioEdit) {
        isRadioEdit = radioEdit;
    }

    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_service_fee)
        TextView tv_service_fee;
        @BindView(R2.id.cb_checked)
        CheckBox cb_checked;

        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public TextView getTvName() {
            return tv_name;
        }

        public TextView getTvServiceFee() {
            return tv_service_fee;
        }

        public TableItem getTableItem(int position) {
            TableItem item = getSectionItem(position);
            return item;
        }
    }

}
