package com.gingersoft.supply_chain.mvp.content;

import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;
import com.xuexiang.rxutil2.rxjava.task.RxIOTask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author zjs.
 * Use:需要緩存用戶選中的食品
 */
public class DishesFoodList {

    /**
     * 供應商信息map
     * 有時候PurchaseFoodBean中的供應商信息不可靠，比如：用戶將食品添加到購物車中，然後又去供應商列表修改供應商信息，這時候需要更新供應商信息
     */
    private static Map<Integer, SupplierInfoBean> supplierInfoBeanMap;
    /**
     * key為食品id
     * value為食品信息
     */
    private static Map<Integer, PurchaseFoodBean> foodBeanMap;

    private static DishesFoodList shoppingCart;

    public static DishesFoodList getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new DishesFoodList();
        }
        return shoppingCart;
    }

    public ArrayList<PurchaseFoodBean> getCartFoods() {
        return new ArrayList<>(getFoodBeanMap().values());
    }

    public Map<Integer, PurchaseFoodBean> getFoodBeanMap() {
        if (foodBeanMap == null) {
            foodBeanMap = new HashMap<>();
        }
        return foodBeanMap;
    }

    public Map<Integer, SupplierInfoBean> getSupplierInfoBeanMap() {
        if (supplierInfoBeanMap == null) {
            supplierInfoBeanMap = new HashMap<>();
        }
        return supplierInfoBeanMap;
    }

    public SupplierInfoBean getSupplierById(int supplierId) {
        return getSupplierInfoBeanMap().get(supplierId);
    }

    public void updateSupplier(SupplierInfoBean supplierInfoBean) {
        getSupplierInfoBeanMap().put(supplierInfoBean.getId(), supplierInfoBean);
    }

    public void addAllFood(Collection<PurchaseFoodBean> purchaseFoodBeans) {
        for (PurchaseFoodBean purchaseFoodBean : purchaseFoodBeans) {
            addFood(purchaseFoodBean);
        }
    }

    /**
     * 添加食品時記錄供應商信息，對供應商進行修改時，需要修改食材的供應商信息
     *
     * @param purchaseFoodBean 食品
     */
    public void addFood(PurchaseFoodBean purchaseFoodBean) {
        getFoodBeanMap().put(purchaseFoodBean.getId(), purchaseFoodBean);
        if (getSupplierInfoBeanMap().get(purchaseFoodBean.getSupplierId()) == null) {
            getSupplierInfoBeanMap().put(purchaseFoodBean.getSupplierId(), SupplierInfoBean.generateSupplierByFood(purchaseFoodBean));
        }
    }

    /**
     * 替換食品信息
     *
     * @param purchaseFoodBean 食品信息
     */
    public void replaceFood(PurchaseFoodBean purchaseFoodBean) {
        //從食品緩衝中拿到這個食品
        PurchaseFoodBean mapFood = getFoodBeanMap().get(purchaseFoodBean.getId());
        //食品不為空並且這個食品的供應商還存在
        if (mapFood != null && getSupplierInfoBeanMap().get(purchaseFoodBean.getSupplierId()) != null) {
            //將要替換的食品數量同步為當前緩存中的數量
            purchaseFoodBean.setFoodQuantity(mapFood.getFoodQuantity());
            //用新的食材數據替換掉舊的，避免有可能修改了其他信息
            getFoodBeanMap().put(purchaseFoodBean.getId(), purchaseFoodBean);
        }
    }

    public void removeFood(PurchaseFoodBean purchaseFoodBean) {
        getFoodBeanMap().remove(purchaseFoodBean.getId());
    }

    public void clear() {
        getFoodBeanMap().clear();
    }

    public PurchaseFoodBean getFoodByFoodId(int foodId) {
        for (PurchaseFoodBean cartFood : getCartFoods()) {
            if (cartFood.getId() == foodId) {
                return cartFood;
            }
        }
        return null;
    }

    public void removeFoodsByFoodId(int foodId) {
        foodBeanMap.remove(foodId);
    }

    public void removeFoodsBySupplier(int supplierId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = DishesFoodList.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getSupplierId() != null && next.getSupplierId() == supplierId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryId(int categoryId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = DishesFoodList.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == categoryId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除分類成功後，需要從購物車數據中將這個分類的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = DishesFoodList.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == foodCategoryTrees.getId()) {
                        iterator.remove();
                    }
                }
                //分類中的刪除完了，需要刪除分類下子分類的食材
                List<OrderCategoryBean.FoodCategoryTrees> childCategory = foodCategoryTrees.getFoodCategoryTrees();
                if (childCategory != null) {
                    //遍歷二級分類
                    for (OrderCategoryBean.FoodCategoryTrees categoryTrees : childCategory) {
                        for (PurchaseFoodBean cartFood : cartFoods) {
                            if (cartFood.getFoodCategoryId() == categoryTrees.getId()) {
                                cartFoods.remove(cartFood);
                                break;
                            }
                        }
                        //對三級分類進行遍歷
                        List<OrderCategoryBean.FoodCategoryTrees> thirdCategory = categoryTrees.getFoodCategoryTrees();
                        removeFoodsByCategoryTress(thirdCategory);
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(List<OrderCategoryBean.FoodCategoryTrees> thirdCategory) {
        if (thirdCategory != null) {
            for (OrderCategoryBean.FoodCategoryTrees trees : thirdCategory) {
                for (PurchaseFoodBean cartFood : getCartFoods()) {
                    if (cartFood.getFoodCategoryId() == trees.getId()) {
                        getFoodBeanMap().remove(cartFood.getId());
                    }
                }
            }
        }
    }

}
