package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;

/**
 *
 */
public interface DishesContract {
    interface View extends IView {
        /**
         * 加載菜品組數據
         */
        void loadDishGroupInfo(DishesResultBean dishGroup);

        void loadDishesInfo(DishesResultBean dishes);

        /**
         * 加載失敗
         */
        void loadFail();

        /**
         * 結束加載並且沒有更多數據了
         */
        void finishLoad(boolean noData);

        /**
         * 加載食品
         *
         * @param buyIngredientsBeans 顯示的食材
         */
        void loadFood(List<BuyIngredientsBean> buyIngredientsBeans);

        void selectDishGroupByIndex(int position);

    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<DishesResultBean> getDishGroupData(Map<String, Object> map);

        Observable<DishesResultBean> getDishesData(Map<String, Object> map);

        Observable<BaseResult> bindDishes(Map<String, Object> map);

    }
}