package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.DishesContract;

import java.util.Map;

import io.reactivex.Observable;

/**
 */
@FragmentScope
public class DishesModel extends BaseModel implements DishesContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public DishesModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<DishesResultBean> getDishGroupData(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getDishesList(map);
    }

    @Override
    public Observable<DishesResultBean> getDishesData(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getDishesList(map);
    }

    @Override
    public Observable<BaseResult> bindDishes(Map<String, Object> map) {
        return null;
    }
}