package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.mvp.bean.DishesBean;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.gingersoft.supply_chain.mvp.contract.DishesContract;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishNode;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishesGroupNode;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.LogUtils;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;

/**
 * ================================================
 * 菜品
 * ================================================
 */
@FragmentScope
public class DishesPresenter extends BasePresenter<DishesContract.Model, DishesContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;


    @Inject
    public DishesPresenter(DishesContract.Model model, DishesContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    public void getDishesData() {
        Map<String, Object> map = new HashMap<>(2);
//        map.put("","0");
        AppConstant.addBrandId(map);
        AppConstant.addRestaurantId(map);
        mModel.getDishesData(map)//發送請求
                .subscribeOn(Schedulers.io())//切換到io異步線程
                .doOnSubscribe(disposable -> mRootView.showLoading(AppConstant.GET_INFO_LOADING))//顯示加載提示框
                .subscribeOn(AndroidSchedulers.mainThread())//切換到主線程，上面的提示框就在主線程
                .observeOn(AndroidSchedulers.mainThread())//切換到主線程，隱藏提示框在主線程
                .doAfterTerminate(() -> mRootView.hideLoading())//任務執行完成後，隱藏提示框
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))//綁定生命週期，頁面隱藏時斷開請求
                .observeOn(AndroidSchedulers.mainThread())//切換到主線程
                .subscribe(new ErrorHandleSubscriber<DishesResultBean>(mErrorHandler) {//mErrorHandler是統一的錯誤處理
                    @Override
                    public void onNext(DishesResultBean orderCategoryBean) {//數據處理
                        if (orderCategoryBean.isSuccess()) {
                            DishesResultBean.DataBean data = orderCategoryBean.getData();
                            if (data != null) {
                                //將分類食品的list容量設置為一級分類的數量，這樣就不用擔心之後加載不同position的分類數據時，計算位置了

                                LogUtils.warnInfo(" zjs ="+data.getCount());
                                List<DishesBean> list= data.getList();
                                List<DishesBean> plist= new ArrayList<>();
                                List<DishesBean> clist= new ArrayList<>();
                                List<DishesGroupNode> pNodes= new ArrayList<>();
                                List<DishNode> cNodes= new ArrayList<>();
//                                Collections.sort(list);
                                long start=System.currentTimeMillis();
                                LogUtils.warnInfo(" zjs ="+list.size() +" start"+start);

                                for (int i = 0; i < list.size(); i++) {
                                    DishesBean dishesBean =list.get(i);
                                    if (dishesBean.isParent()) {
                                        clist.add(dishesBean); //子菜单
//                                        DishNode cNode=new DishNode(dishesBean);
//                                        cNodes.add(cNode);
                                    }else {
                                        plist.add(dishesBean);//父菜单
                                        DishesGroupNode groupNode=new DishesGroupNode(dishesBean);
                                        pNodes.add(groupNode);
                                    }
                                    LogUtils.warnInfo(" zjs =" + list.get(i).toString());
                                }
                                int len=clist.size();
                                for (int i = 0; i < pNodes.size(); i++) {
                                    DishesGroupNode groupNode= pNodes.get(i);
                                    List<DishNode> subNode= new ArrayList<>();
                                    for (int j = 0; j < len; j++) {
                                        DishesBean dishesBean =clist.get(i);
                                        if (groupNode.getId() == dishesBean.getParentId()) {
                                            DishNode cNode=new DishNode(dishesBean);
                                            subNode.add(cNode);
                                        }
                                    }
                                    groupNode.setDishNodes(subNode);

                                }

                                LogUtils.warnInfo(" zjs end="+(System.currentTimeMillis()-start));

                            }


                            //第一次加載初始化數量
//                            initCategoryGoodsSize(data);
//                            mRootView.initCategoryInfo(data);
                        } else if (TextUtil.isNotEmptyOrNullOrUndefined(orderCategoryBean.getErrMsg())) {
                            mRootView.showMessage(orderCategoryBean.getErrMsg());
                        } else {
                            mRootView.showMessage(AppConstant.GET_INFO_ERROR);
                        }
                    }
                });
    }

}