package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.entity.node.BaseExpandNode;
import com.chad.library.adapter.base.entity.node.BaseNode;
import com.gingersoft.supply_chain.mvp.bean.DishesBean;

import java.util.List;

public class DishNode extends BaseExpandNode {
    private int id;
    private int parentId;
    private int restaurantId;
    private boolean isParent;
    private int seqNo;
    private String foodName;

    private List<BaseNode> childNode;

    public DishNode(DishesBean dishesBean) {
        this.id = dishesBean.getId();
        this.parentId = dishesBean.getParentId();
        this.restaurantId = dishesBean.getRestaurantId();
        this.isParent = dishesBean.isParent();
        this.seqNo = dishesBean.getSeqNo();
        this.foodName = dishesBean.getFoodName();
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentId() {
        return parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public boolean isParent() {
        return isParent;
    }

    public void setParent(boolean parent) {
        isParent = parent;
    }

    public int getSeqNo() {
        return seqNo;
    }

    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public DishNode(List<BaseNode> childNode) {
        this.childNode = childNode;

        setExpanded(false);
    }
 
    public String getTitle() {
        return foodName;
    }

    @Override
    public String toString() {
        return "DishNode{" +
                "id=" + id +
                ", parentId=" + parentId +
                ", restaurantId=" + restaurantId +
                ", isParent=" + isParent +
                ", seqNo=" + seqNo +
                ", foodName='" + foodName + '\'' +
                ", childNode=" + childNode +
                '}';
    }

    @Nullable
    @Override
    public List<BaseNode> getChildNode() {
        return childNode;
    }
}