package com.gingersoft.gsa.cloud.table.mvp.model.table.action;

import android.app.Activity;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.common.constans.PrintConstans;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintContent;
import com.gingersoft.gsa.cloud.print.bean.adapter.PrintContentAdapter;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.OrderAssemblyUtil;
import com.gingersoft.gsa.cloud.table.mvp.presenter.TablePresenter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯模式-打印上菜紙{@link com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity}
 */
public class PrintServingPaperAction extends TableAction {

    private TablePresenter mTablePresenter;

    public PrintServingPaperAction(Activity context, TablePresenter tablePresenter) {
        super(context, "上菜紙", "請選擇檯號", "");
        this.mTablePresenter = tablePresenter;
    }

    @Override
    public void action(TableBean.DataBean dataBean) {
        setOperatContentText(dataBean.getTableName());
        if (dataBean.getSplitStatus() == 1) {
            showSplitTableDialogAction();
        } else {
            showActionTipDialog(dataBean);
        }
    }

    @Override
    public boolean filterTableCondition(TableBean.DataBean dataBean) {
        return dataBean.getStatus() != 0;
    }

    @Override
    public void destroy() {
        mTablePresenter = null;
    }

    public void showActionTipDialog(TableBean.DataBean tableBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mContext);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否確認打印");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                mTablePresenter.loadOrderToPrintParper(tableBean, new OnNetworkCallbackListener<BaseOrderResponse>() {

                    @Override
                    public void onResult(BaseOrderResponse respose) {

                        if (respose.isSuccess()) {

                            DoshokuOrder doshokuOrder = DoshokuOrder.getInstance();
                            doshokuOrder.setOpenTableInfo(new TableBean.DataBean());

                            TableBean.DataBean tableInfo = doshokuOrder.getOpenTableInfo();
                            tableInfo.setPerson(0);

                            OrderResponse orderBean = respose.getData();
                            if (orderBean != null && respose.getData().getOrderDetails() != null) {
                                if (respose.getData().getCreateTime() != null && tableBean != null) {
                                    //將開台時間設置為訂單創建時間
                                    tableBean.setCreateTime(respose.getData().getCreateTime());
                                }
                                tableInfo.setPerson(orderBean.getPerson());

                                List<OrderResponse.OrderDetailsBean> orderDetailsBeans = respose.getData().getOrderDetails();

                                //緩存訂單信息
                                doshokuOrder.setOrderPlaced(new OrderResponse(orderBean));
                                //緩存食品信息
                                List<OrderDetail> orderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailsBeans));

                                doshokuOrder.getShoppingCart().setOrderCommodityList(orderDetailList);
                            } else {
                                doshokuOrder.setOrderPlaced(null);
                                doshokuOrder.getShoppingCart().setOrderCommodityList(new ArrayList<>());
                            }
                            doshokuOrder.setOpenTableInfo(tableBean);

                            printParper();
                        } else {
                            CommonTipDialog.showSurpisedDialog(mContext, respose.getErrMsg(), null, null, null, null, null);
                        }
                    }

                    @Override
                    public void onError(Throwable t) {

                    }

                    @Override
                    public void onComplete() {

                    }
                });
                dialog.dismiss();
            }
        });
        dialogBuilder.addAction("取消", new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                cancel();
            }
        });
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }


    /**
     * 打印上菜紙
     */
    private void printParper() {
        PrintContent printContent = new PrintContentAdapter().adaptationServingPaperContent(DoshokuOrder.getInstance());
        CC.obtainBuilder(ComponentName.COMPONENT_PRINT)
                .setActionName("printActivity")
                .addParam(PrintConstans.PRINT_TYPE, PrintConstans.PRINT_SERVE)
                .addParam(PrintConstans.PRINT_CONTENT,printContent)
                .build()
                .callAsyncCallbackOnMainThread((cc, result) -> {
                    //清空賬單數據
                    DoshokuOrder.getInstance().initialization();
                    cancel();
                });
    }

}
