package com.gingersoft.gsa.cloud.pay.pos.bean;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2020-12-25 17:53
 * @更新時間: 2020-12-25 17:53
 * @描述: 事項實體
 */
@Data
public class PosMatter implements Parcelable {

    private Long id;
    /**
     * N5支付ID（N5支付 TXN_ID 唯一標示，雲端GSA生成）
     */
    private String payId;
    /**
     * N5退款ID（N5退款 Refund_ID 唯一標示，雲端GSA生成）
     */
    private String refundId;
    /**
     * 設備ID
     */
    private String deviceId;
    /**
     * 訂單ID
     */
    private Long orderId;
    /**
     * 事項類型：1 支付，2 取消，3 退款，4 追加小費，5 清機
     */
    private Byte businessType;
    /**
     * 狀態：0 未處理，1 成功，2 失敗
     */
    private Byte status;

    public static final byte status_0 = 0;
    public static final byte status_1 = 1;
    public static final byte status_2 = 2;

    /**
     * 主檯ID
     */
    private Long tableId;
    /**
     * 分檯ID
     */
    private Long tableExtId;
    /**
     * 支付方式ID
     */
    private Long payMethodId;
    /**
     * 支付金額
     */
    private Double amount;
    /**
     * N5回調內容
     */
    private String content;

    /**
     * 線下支付方式 1 為找零   2 為貼上
     */
    private Byte linePayType;

    /**
     * linePayType 等於 1 則tipsPrice為找零， 等於 2 則tipsPrice為貼上
     */
    private Double tipsPrice;

    public static final double POINTS = 0.00;


    public PosMatter() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.id);
        dest.writeString(this.payId);
        dest.writeString(this.refundId);
        dest.writeString(this.deviceId);
        dest.writeValue(this.orderId);
        dest.writeValue(this.businessType);
        dest.writeValue(this.status);
        dest.writeValue(this.tableId);
        dest.writeValue(this.tableExtId);
        dest.writeValue(this.payMethodId);
        dest.writeValue(this.amount);
        dest.writeString(this.content);
        dest.writeValue(this.linePayType);
        dest.writeValue(this.tipsPrice);
    }

    protected PosMatter(Parcel in) {
        this.id = (Long) in.readValue(Long.class.getClassLoader());
        this.payId = in.readString();
        this.refundId = in.readString();
        this.deviceId = in.readString();
        this.orderId = (Long) in.readValue(Long.class.getClassLoader());
        this.businessType = (Byte) in.readValue(Byte.class.getClassLoader());
        this.status = (Byte) in.readValue(Byte.class.getClassLoader());
        this.tableId = (Long) in.readValue(Long.class.getClassLoader());
        this.tableExtId = (Long) in.readValue(Long.class.getClassLoader());
        this.payMethodId = (Long) in.readValue(Long.class.getClassLoader());
        this.amount = (Double) in.readValue(Double.class.getClassLoader());
        this.content = in.readString();
        this.linePayType = (Byte) in.readValue(Byte.class.getClassLoader());
        this.tipsPrice = (Double) in.readValue(Double.class.getClassLoader());
    }

    public static final Creator<PosMatter> CREATOR = new Creator<PosMatter>() {
        @Override
        public PosMatter createFromParcel(Parcel source) {
            return new PosMatter(source);
        }

        @Override
        public PosMatter[] newArray(int size) {
            return new PosMatter[size];
        }
    };
}
