package com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.etps.aca.lib.constant.Constant;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.pay.contract.PayErrorCode;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.bean.PosMatter;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.RetrievalRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.RefundRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.SaleRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayStatusCode;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.RxLifecycleUtils;

import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:38
 * @更新時間: 2020-12-26 10:38
 * @描述:查詢狀態，支持（銷售/退款）
 */
public class RetrievalActionImpl extends IPosAction {

    private RetrievalRequest mRetrievalRequest;
    private long mOrderId;

    public RetrievalActionImpl(Context context, IView iView, PosAction action, long orderId,RetrievalRequest request, OnPosActionListener onPosActionListener, boolean showLoading) {
        super(context, iView, action, showLoading);
        this.mOrderId = mOrderId;
        this.mRetrievalRequest = request;
        this.mOnPosActionListener = onPosActionListener;
    }

    @Override
    protected void onRequestBefore() {
        //調起N5狀態查詢
        onRequestPOS(GsonUtils.GsonString(mRetrievalRequest));
    }

    /**
     * 查詢回調成功
     * 1、更新上傳狀態
     *
     * @param context
     * @param response
     * @param originalActivity
     */
    @Override
    public void onActionComplte(Context context, HywebPosResponse response, Activity originalActivity) {

        if (PayStatusCode.withException(response.getSTATUS())) {
            onActionError(new Exception("回調異常" + PayErrorCode.pos_response_102));
        } else {
            if (mOnPosActionListener != null) {
                mOnPosActionListener.onPosSuccess(response);
            }
        }

        String url = null;
        RequestBody requestBody;
        switch (response.getEVENT_NAME()) {
            case Constant.EVENT.NAME.SALE_RESP:
                url = "posPay/updatePosMatter";
                requestBody = getPosMatterSaleRequest((SaleRespose) response);
                break;
            case Constant.EVENT.NAME.REFUND_RESP:
                url = "posPay/updatePosRefund";
                requestBody = getPosMatterRefundRequest((RefundRespose) response);
                break;
            default:
                return;
        }
        //1、更新上傳支付狀態
        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + url, requestBody)
                .subscribeOn(Schedulers.io())
                .observeOn(Schedulers.io())
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .compose(RxLifecycleUtils.bindToLifecycle(mView))
                .subscribe(new Observer<String>() {
                    @Override
                    public void onSubscribe(Disposable d) {
                    }

                    @Override
                    public void onNext(String result) {
                        if (!TextUtils.isEmpty(result)) {
                            BaseResult baseResult = GsonUtils.GsonToBean(result, BaseResult.class);
                            if (baseResult != null) {
                                if (baseResult.isSuccess() && baseResult.getData() != null) {
                                    if (mOnPosActionListener != null) {
                                        mOnPosActionListener.onSuccess(response);
                                    }
                                } else {
                                    onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.sale_412));
                                }
                            } else {
                                onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.sale_413));
                            }
                        } else {
                            onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.sale_414));
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (mOnPosActionListener != null) {
                            mOnPosActionListener.onError(e);
                        }
                    }

                    @Override
                    public void onComplete() {
                    }

                });
    }

    private RequestBody getPosMatterSaleRequest(SaleRespose response) {

        PosMatter posMatter = new PosMatter();
        posMatter.setOrderId(mOrderId);
        posMatter.setPayId(response.getTXN_ID());
        posMatter.setContent(GsonUtils.GsonString(response));
        posMatter.setStatus(getPosMatterStatus(response.getSTATUS()));
//        mMealOrderPayRequest.setPosMatter(posMatter);

        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(posMatter));
        String json = GsonUtils.GsonString(posMatter);

        return requestBody;
    }

    private RequestBody getPosMatterRefundRequest(RefundRespose response) {

        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(response));
        String json = GsonUtils.GsonString(response);

        return requestBody;
    }

}
