package com.gingersoft.gsa.cloud.pay.util;

import com.gingersoft.gsa.cloud.pay.bean.PayMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2020-12-28 10:36
 * @更新時間: 2020-12-28 10:36
 * @描述:
 */
public class PayMethodUtils {


    public static List<PayMethod> filterPaymentsMethodById(List<PayMethod> payMethods, int... types) {
        List<PayMethod> payMethodList = new ArrayList<>();
        if (payMethods != null && payMethods.size() > 0 && types.length > 0) {
            for (int type : types) {
                for (PayMethod payMethod : payMethods) {
                    if (payMethod.getPayType() == type) {
                        payMethodList.add(payMethod);
                    }
                }
            }
        }
        return payMethodList;
    }

    public static PayMethod filterPaymentMethodById(List<PayMethod> payMethods, int type) {
        if (payMethods != null && payMethods.size() > 0 && type != 0) {
            for (PayMethod payMethod : payMethods) {
                if (payMethod.getPayType() == type) {
                    return payMethod;
                }
            }
        }
        return null;
    }
}
