package com.gingersoft.gsa.cloud.base.adapter.print;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.database.bean.Food;
import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/9.
 */
public class FoodAdapter extends BaseQuickAdapter<Food, BaseViewHolder> {

    public FoodAdapter(@Nullable List<Food> data) {
        super(R.layout.print_item_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, Food item) {
        helper.setText(R.id.tv_food_name, item.getFoodName());
        helper.setText(R.id.tv_food_quantity, String.valueOf(item.getNumber()));
        helper.setText(R.id.tv_food_price, "$" + item.getPrice());
    }
}
