package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Application;
import android.content.Intent;
import android.graphics.Bitmap;
import android.widget.BaseAdapter;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableContract;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.base.utils.PrintUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseRespose;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.request.OrderRequest;
import com.gingersoft.gsa.cloud.table.mvp.model.constant.MealConstant;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.MealStandActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class MealStandPresenter extends BasePresenter<MealStandContract.Model, MealStandContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private MealStandActivity IActivity;

    //订单数据管理类
    private MyOrderManage myOrderManage;

    private SelectMealAdapter mSelectMealAdapter;
    private FoodAdapter mFoodAdapter;

    private List<Food> mFoodGroupList;
    //食品数据
    private List<Food> mFoodList = new ArrayList<>();

    private boolean RvMealClicked;

    @Inject
    public MealStandPresenter(MealStandContract.Model model, MealStandContract.View rootView) {
        super(model, rootView);
        this.IActivity = (MealStandActivity) rootView;

        myOrderManage = MyOrderManage.getInstance();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initMealData() {

        mFoodGroupList = mModel.queryDB_FoodGroupList();

        if (mFoodGroupList != null && mFoodGroupList.size() > 0) {

            IActivity.initFoodGroupView(mFoodGroupList);

            changedMealByParentId(mFoodGroupList.get(0).getId());
        }
    }

    public void initAdapter() {
        if (mSelectMealAdapter == null) {
//            List<Food> foods = new ArrayList<>();
//            foods.addAll(myOrderManage.getOrderFoodList());
            mSelectMealAdapter = new SelectMealAdapter(IActivity, myOrderManage.getOrderFoodList(), this);
            mRootView.setSelectFoodAdapter(mSelectMealAdapter);
        }
//        myOrderManage.setSelectMealAdapter(mSelectMealAdapter);
        if (mFoodAdapter == null) {
            mFoodAdapter = new FoodAdapter(IActivity, mFoodList);
            mRootView.setFoodAdapter(mFoodAdapter);
        }
    }

    public void initItemClickListener() {
        mSelectMealAdapter.setOnItemClickListener(new SelectMealAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(Food datasBean, int position) {

                mRootView.recordOperat(true);

                RvMealClicked = true;

            }
        });
        mFoodAdapter.setOnItemClickListener(new FoodAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(Food datasBean, int position) {

                mRootView.recordOperat(true);

                if (!foodConditionFilter(datasBean)) {
                    return;
                }

                RvMealClicked = false;

                int addPosition = mSelectMealAdapter.addFoodItem(datasBean);
                mRootView.setMealRvScrollToPosition(addPosition);

                updateOrderFoodNumber();
            }
        });
    }

    public void createOrder() {
        OrderRequest request = getCreateOrderRequest(getOrderFoodLists());
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), JsonUtils.toJson(request));
        mModel.createOrder(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        if (info != null && info.isSuccess()) {
                            mRootView.showMessage("送單成功");
                            printSendOrder(MyOrderManage.getInstance().getOrderFoodList());
//                            IActivity.returnTableActivity(true);
                        } else {
                            mRootView.showMessage("送單失敗");
                        }
                    }
                });
    }

    /**
     * 篩選出兩個list不同的對象
     *
     * @param listA
     * @param listB
     * @param <T>
     * @return
     */
    private <T> List<T> getDiff(List<T> listA, List<T> listB) {
        List<T> diff = new ArrayList<>();
        List<T> maxList = listA;
        List<T> minList = listB;
        if (listB.size() > listA.size()) {
            maxList = listB;
            minList = listA;
        }
        Map<T, Integer> map = new HashMap<>(maxList.size());
        for (T t : maxList) {
            map.put(t, 1);
        }
        for (T t : minList) {
            if (map.get(t) != null) {
                map.put(t, 2);
                continue;
            }
            diff.add(t);
        }
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (entry.getValue() == 1) {
                diff.add(entry.getKey());
            }
        }
        return diff;
    }

    public void addOrderFood() {
//        List<Food> foods = getDiff(MyOrderManage.getInstance().getOrderFoodList(), mSelectMealAdapter.getInfos());
        List<Food> foods = MyOrderManage.getInstance().getOrderFoodList();
        List<Food> newFoods = new ArrayList<>();
        for (Food food : foods) {
            if (food.getIsNew()) {
                newFoods.add(food);
            }
        }
        for (Food food : newFoods) {
            food.setOrderId(MyOrderManage.getInstance().getOrderId());
        }
        List<OrderBean.OrderDetailsBean> orderBeans = OrderBean.transOrderDetails(newFoods);
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), JsonUtils.toJson(orderBeans));
        mModel.addFood(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        if (info != null && info.isSuccess()) {
                            mRootView.showMessage("送單成功");
//                            mRootView.launchActivity(new Intent(IActivity, MealStandActivity.class));
                            printSendOrder(newFoods);
                        } else {
                            mRootView.showMessage("送單失敗");
                        }
                    }
                });
    }

    /**
     * 打印上菜紙
     * 打印廚房單
     */
    private void printSendOrder(List<Food> newFoods) {
        //打印廚房單
        CC.obtainBuilder("Component.Print")
                .setActionName("printActivity")
                .addParam("NewFoods", newFoods)
                .addParam("type", 3)
                .build()
                .callAsync((cc, result) -> {
                    if (result.isSuccess()) {
                        //打印成功
                        mRootView.killMyself();
                    }
                });


        //打印上菜紙
//        CC.obtainBuilder("Component.Print")
//                .setActionName("printActivity")
//                .addParam("NewFoods", newFoods)
//                .addParam("type", 0)
//                .build()
//                .callAsync((cc, result) -> {
//                    if (result.isSuccess()) {
//                        //打印成功
//                        mRootView.killMyself();
//                    }
//                });
    }

    public void deleteFood(long id) {

        RequestBody requestBody = new FormBody.Builder()
                .add("id", id + "")
                .build();

        mModel.deleteFood(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseRespose>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull BaseRespose info) {
                        if (info != null && info.isSuccess()) {
                            mRootView.showMessage("刪除成功");
                        } else {
                            mRootView.showMessage("刪除失敗");
                        }
                    }
                });
    }

    public void sendOrder() {
        if (MyOrderManage.getInstance().getOrderId() == -1) {
            createOrder();
        } else {
            addOrderFood();
        }
    }

    private void deleteWithOrderedFoodById(Long id) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(IActivity);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setMessage("是否確認刪除該食品?");
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            int deletePosition = mSelectMealAdapter.removeFoodItem();
            mRootView.setMealRvScrollToPosition(deletePosition);
            deleteFood(id);
        });
        dialogBuilder.create(R.style.QMUI_Dialog).show();
    }

    /**
     * 刪除食品
     *
     * @param deleteStyle 1=點擊刪除、2=長按刪除
     */
    public void deleteFoodItem(int deleteStyle) {

        if (mSelectMealAdapter.getSelect_position() >= getOrderFoodLists().size()) {
            return;
        }
        //未選擇食品時，設置默認選擇最後一個
        if (mSelectMealAdapter.getSelect_position() == -1) {
            if (getOrderFoodLists().size() > 0) {
                mSelectMealAdapter.setSelectPosition(getOrderFoodLists().size() - 1);
            }
        }
        Food deleteFood = getOrderFoodLists().get(mSelectMealAdapter.getSelect_position());

        if (!deleteFood.isNew()) {
            //TODO 刪除已下單食品
            deleteWithOrderedFoodById(deleteFood.getId());
        } else {
            if (deleteStyle == 2) {
                mSelectMealAdapter.removeAllNewFoodItem();
            } else {
                int deletePosition = mSelectMealAdapter.removeFoodItem();
                mRootView.setMealRvScrollToPosition(deletePosition);
//                deleteFood(deleteFood.getId());
            }
        }
        updateOrderFoodNumber();
    }

    public void changedMealByParentId(long parentId) {
        List<Food> foodList = mModel.queryDB_FoodList(parentId);
        mFoodAdapter.resetSelect(-1, null);
        if (foodList != null) {
            mFoodList.clear();
            mFoodList.addAll(foodList);
            //根据Item个数显示每一行的个数
            mRootView.setFoodRecycleSpanCount(mFoodList.size());
            mFoodAdapter.notifyDataSetChanged();
        }
        mRootView.showViewModeVisibility(MealConstant.food_ViewMode, MealConstant.food_group_ViewMode);

    }


    /**
     * 按键入的食品号查找食品
     * meal_uid:即可以是食品的fid也可以是PLU码。
     * 未有此商品，弹出提示框并且清除录入
     * 有此商品，把商品上屏并且清除录入
     *
     * @param plu
     */
    public void toFindMeal(String plu) {

        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(IActivity);
        Food food = foodDaoUtils.queryFoodByQueryBuilder(plu);

        //查找成功清除输入框
        IActivity.clearInput();

        if (food == null) {
            mRootView.showMessage("未找到該食品!");
            return;
        }

        int addPosition = mSelectMealAdapter.addFoodItem(food);
        mRootView.setMealRvScrollToPosition(addPosition);

        updateOrderFoodNumber();
    }

    /**
     * 设置当前食品还可最多选几份
     *
     * @param foodBean
     */
    public boolean setUserMaxQty(Food foodBean) {

        int currentSelectNumber = 0;

        for (int i = 0; i < getOrderFoodLists().size(); i++) {
            Food orderFood = getOrderFoodLists().get(i);
            if (orderFood.getId() == foodBean.getId()) {
                currentSelectNumber += orderFood.getNumber();
            }
        }

//        String User_Qty = foodBean.getOR_Qty();
//        if (!User_Qty.equals("") && !User_Qty.equals("售罄") && !User_Qty.equals("暫停")) {
//            int maxQty = Integer.parseInt(User_Qty);
//            if (maxQty > 0) {
//                int Currrent_OR__Qty = maxQty - currentSelectNumber;
//                if (Currrent_OR__Qty < 1) {
//                    foodBean.setCurrrent_OR_Qty("售罄");
//                    return false;
//                } else {
//                    foodBean.setCurrrent_OR_Qty(Currrent_OR__Qty + "");
//                }
//            }
//        }
        return true;
    }

    /**
     * 添加食品条件过滤
     * 1：售罄、最大选择数
     * 2：是否需要会员积分
     * 3：
     */
    public boolean foodGroupConditionFilter(Food foodBean, boolean init) {

        if (init) {
            return true;
        }

//        String User_Qty = foodBean.getOR_Qty();
//        if (!TextUtils.isEmpty(User_Qty)) {
//            TitleDialog.showTitledialog(IActivity, foodBean.getName()
//                            + LanguageUtils.get_language_system(IActivity, "Comm.pause", "已暫停(Comm.pause)"),
//                    "", LanguageUtils.get_language_system(IActivity, "comm.ok", "ok(comm.ok)"), "", null);
//            return false;
//        }

        return true;
    }

    private boolean foodConditionFilter(Food foodBean) {

        int isSold = foodBean.getIsSold();
        if (isSold == 1) {
            mRootView.showMessage("已售罄");
            return false;
        }

//        String User_Qty = foodBean.getCurrrent_OR_Qty();
//
//        if (!TextUtils.isEmpty(User_Qty)) {
//            if (User_Qty.equals("售罄") || User_Qty.equals("暫停")) {
//                TitleDialog.showTitledialog(IActivity, foodBean.getName()
//                                + LanguageUtils.get_language_system(IActivity, "Comm.pause", "已暫停(Comm.pause)"),
//                        "", LanguageUtils.get_language_system(IActivity, "comm.ok", "ok(comm.ok)"), "", null);
//                return false;
//            }
//        }
//
//        if (GSAApplication.tableContract.getMember() == null) {
//            //当前食品需要会员积分
//            if (foodBean.getPointsRedeem() > 0) {
//                mRootView.showMessage(LanguageUtils.get_language_system(mApplication, "unused_members_can.not.order.food", "積分食品，未使用會員，不可點選") + "\"" + foodBean.getName() + "\"");
//                return false;
//            }
//        } else {
//            if (GSAApplication.tableContract.getMember().getDatas() != null) {
//                //如果没有会员，则pointsadd=5是加5分  pointsredeem=5是減5分
//                //當一張臺號沒有會員登錄時判定積分為0 不能為負數
//                //	此時call pointsredeem=5  的食物   不給過
//                //點選pointsadd=5的食物  0+5 是正數  這個給過
//                if (foodBean.getPointsRedeem() > 0 && GSAApplication.tableContract.getMember().getDatas().getData().getMemberPoint() < foodBean.getPointsRedeem()) {
//                    mRootView.showMessage(LanguageUtils.get_language_system(mApplication, "insufficient.points.can.not.selected", "積分食品，會員積分不足，不可點選") + "\"" + foodBean.getName() + "\"");
//                    return false;
//                }
//            }
//        }

        return true;
    }

    private void updateOrderFoodNumber() {

        setFoodBtnNumber();
        setFoodGroupBtnNumber(IActivity.getFoodGroupGridViewAdapter(), mFoodGroupList);

        mRootView.setOrderFoodCount(getOrderFoodNumber());
    }

    private void setFoodBtnNumber() {
        for (int i = 0; i < mFoodList.size(); i++) {
            Food foodBean = mFoodList.get(i);
            foodBean.setNumber(0);
            int iNumber = 0;
            if (getOrderFoodLists() != null) {
                for (int j = 0; j < getOrderFoodLists().size(); j++) {
                    Food food = getOrderFoodLists().get(j);
                    if (food.isNew() && food.getId() == foodBean.getId()) {
                        iNumber = iNumber + food.getNumber();
                        foodBean.setNumber(iNumber);
                    }
                }
            }
        }
        mFoodAdapter.notifyDataSetChanged();
    }

    private void setFoodGroupBtnNumber(BaseAdapter adapter, List<Food> foodGroupList) {
        for (int i = 0; i < foodGroupList.size(); i++) {
            Food foodBean = foodGroupList.get(i);
            foodBean.setNumber(0);
            int iNumber = 0;
            if (getOrderFoodLists() != null) {
                for (int j = 0; j < getOrderFoodLists().size(); j++) {
                    Food food = getOrderFoodLists().get(j);
                    if (food.isNew() && food.getId() == foodBean.getId()) {
                        iNumber = iNumber + food.getNumber();
                        foodBean.setNumber(iNumber);
                    }
                }
            }
        }
        if (adapter != null)
            adapter.notifyDataSetChanged();
    }

    private String getOrderFoodNumber() {
        int i = 0;
        if (getOrderFoodLists() != null) {
            for (int j = 0; j < getOrderFoodLists().size(); j++) {
                Food order = getOrderFoodLists().get(j);
                if (order.isNew()) {
                    i = i + order.getNumber();
                }
            }
        }
        return String.valueOf(i);
    }

    private OrderRequest getCreateOrderRequest(List<Food> foodList) {
        OrderRequest request = new OrderRequest();
        request.setOrderDetails(foodBeanToFoodRequest(foodList));
        request.setPerson(OpenTableContract.getDefault().getTableBean().getPeopleNumber());
        request.setTableId(OpenTableContract.getDefault().getTableBean().getId());
        return request;
    }

    private OrderRequest getAddOrderFoodRequest(List<Food> foodList) {
        OrderRequest request = new OrderRequest();
        request.setOrderDetails(foodBeanToFoodRequest(foodList));
        return request;
    }

    private List<OrderRequest.Request> foodBeanToFoodRequest(List<Food> foodList) {
        List<OrderRequest.Request> requests = new ArrayList<>();
        if (foodList != null) {
            for (Food food : foodList) {
                OrderRequest.Request request = new OrderRequest.Request();
                request.setProductName(food.getFoodName());
                request.setProductId(food.getId());
                request.setNumber(food.getNumber());
                request.setPrice(food.getPrice());
                request.setLunchboxPrice(0);
                requests.add(request);
            }
        }
        return requests;
    }

    public Food getOrderFoodById(long id) {
        for (int i = 0; i < mFoodList.size(); i++) {
            Food foodBean = mFoodList.get(i);
            if (id == foodBean.getId()) {
                return foodBean;
            }
        }
        return null;
    }

    public List<Food> getOrderFoodLists() {
        return myOrderManage.getOrderFoodList();
    }

    public boolean isRvMealClicked() {
        return RvMealClicked;
    }

    public void setRvMealClicked(boolean rvMealClicked) {
        RvMealClicked = rvMealClicked;
    }
}
