package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.base.common.bean.BillMethodBean;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/17.
 */
public class BillMoneyAdapter extends BaseQuickAdapter<BillMethodBean, BaseViewHolder> {

    public View.OnClickListener onDeleteClickListenter;

    public BillMoneyAdapter(@Nullable List<BillMethodBean> data) {
        super(R.layout.item_bill_money, data);
    }

    public void setDeleteClickListenter(View.OnClickListener onClickListener){
        this.onDeleteClickListenter = onClickListener;
    }

    @Override
    protected void convert(BaseViewHolder helper, BillMethodBean item) {
        helper.setText(R.id.tv_bill_method_name, item.getName() + "：");
        helper.setText(R.id.tv_bill_money, "$" + item.getMoney() + "");
        helper.addOnClickListener(R.id.iv_bill_delete);
    }

}
