package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Transient;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */

@Entity
public class Food implements Serializable {

    private static final long serialVersionUID = -3341972316262518814L;
    @Id(autoincrement = true)
    private Long id;
    private long orderId;

    @NotNull
    private int parentId;
    private String foodName;

    private int restaurantId;
    private double price;
    private int totalSold;
    private int isSold;
    private String plu;
    private double lunchboxPrice;

    private String printseting;//打印設定，用逗號分隔，*=切紙
    /**
     * 自定義字段
     */
    @Transient
    private boolean isSelected = false;
    @Transient
    private int number = 0;
    @Transient
    private int parentIndex = 0;
    @Transient
    private int myIndex = 0;
    @Transient
    private boolean isNew = true;//是否是新添加的食品（未送單）
    @Transient
    private boolean visible = true;


    @Generated(hash = 866324199)
    public Food() {
    }

    public Food(Long id, int parentId, String foodName, double price, int number, boolean visible, double lunchboxPrice) {
        this.id = id;
        this.parentId = parentId;
        this.foodName = foodName;
        this.price = price;
        this.number = number;
        this.visible = visible;
        this.lunchboxPrice = lunchboxPrice;
    }

    public Food(Food addFood) {
        this.id = addFood.id;
        this.parentId = addFood.parentId;
        this.foodName = addFood.foodName;
        this.restaurantId = addFood.restaurantId;
        this.price = addFood.price;
        this.totalSold = addFood.totalSold;
        this.isSold = addFood.isSold;
        this.plu = addFood.plu;
        this.number = 1;
    }

    @Generated(hash = 449660732)
    public Food(Long id, long orderId, int parentId, String foodName, int restaurantId, double price, int totalSold,
            int isSold, String plu, double lunchboxPrice, String printseting) {
        this.id = id;
        this.orderId = orderId;
        this.parentId = parentId;
        this.foodName = foodName;
        this.restaurantId = restaurantId;
        this.price = price;
        this.totalSold = totalSold;
        this.isSold = isSold;
        this.plu = plu;
        this.lunchboxPrice = lunchboxPrice;
        this.printseting = printseting;
    }

    public double getLunchboxPrice() {
        return lunchboxPrice;
    }

    public void setLunchboxPrice(double lunchboxPrice) {
        this.lunchboxPrice = lunchboxPrice;
    }

    public long getOrderId() {
        return orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    public boolean isSelected() {
        return isSelected;
    }

    public void setSelected(boolean selected) {
        isSelected = selected;
    }

    public int getNumber() {
        return number;
    }

    public String getPrintseting() {
        return printseting;
    }

    public void setPrintseting(String printseting) {
        this.printseting = printseting;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getParentId() {
        return parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getTotalSold() {
        return totalSold;
    }

    public void setTotalSold(int totalSold) {
        this.totalSold = totalSold;
    }

    public int getIsSold() {
        return isSold;
    }

    public void setIsSold(int isSold) {
        this.isSold = isSold;
    }

    public String getPlu() {
        return plu;
    }

    public void setPlu(String plu) {
        this.plu = plu;
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public int getParentIndex() {
        return parentIndex;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    public int getMyIndex() {
        return myIndex;
    }

    public void setMyIndex(int myIndex) {
        this.myIndex = myIndex;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public String toString() {
        return "Food{" +
                "id=" + id +
                ", parentId=" + parentId +
                ", foodName='" + foodName + '\'' +
                ", restaurantId=" + restaurantId +
                ", price=" + price +
                ", totalSold=" + totalSold +
                ", isSold=" + isSold +
                ", plu='" + plu + '\'' +
                ", isSelected=" + isSelected +
                ", number=" + number +
                ", parentIndex=" + parentIndex +
                ", myIndex=" + myIndex +
                ", isNew=" + isNew +
                ", visible=" + visible +
                '}';
    }
}
