package com.gingersoft.gsa.cloud.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.R2;
import com.gingersoft.gsa.cloud.ui.bean.TagViewBean;
import com.gingersoft.gsa.cloud.ui.widget.RoundButton;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/11/27
 * 修订历史：2018/11/27
 * 描述：
 */
public class SkyorderMealKindAdapter extends DefaultAdapter<TagViewBean> {

    private Context mContext;
    private int mCurrentSelectedTagId;

    private boolean firstInit = true;
    //默认选中那一个
    private int defaultCheckedIndex = -1;

    //一行多少个
    private int colCount = 3;
    //每个Item的宽度
    private int itemWidth = 0;
    //每个Item的高度
    private int itemHegiht = 0;

    //显示布局的宽度
    private int showLayoutWidth;


    public SkyorderMealKindAdapter(Context context, List<TagViewBean> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<TagViewBean> getHolder(View v, int viewType) {
        return new TagViewItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_skyorder_meal_kind;
    }

    class TagViewItemHolder extends BaseHolder<TagViewBean> {

        @BindView(R2.id.btn_meal_kind)
        RoundButton btn_meal_kind;
        @BindView(R2.id.iv_selected)
        ImageView iv_selected;


        public TagViewItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(TagViewBean tagViewBean, int position) {

            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) btn_meal_kind.getLayoutParams();
//            //設置Tag宽高以及间距
//            if (itemWidth != 0) {
//                params.width = itemWidth - ArmsUtils.dip2px(mContext, 8);
//                params.leftMargin = ArmsUtils.dip2px(mContext, 7);
//            }
            if (itemHegiht != 0) {
                params.height = ArmsUtils.dip2px(mContext, itemHegiht);
            }
//            params.leftMargin = ArmsUtils.dip2px(mContext, 7);
            btn_meal_kind.setLayoutParams(params);

            btn_meal_kind.setText(tagViewBean.getTagName());

            if (!firstInit) {
                if (tagViewBean.isChecked()) {
                    mCurrentSelectedTagId = tagViewBean.getId();
                    iv_selected.setVisibility(View.VISIBLE);
                } else {
                    iv_selected.setVisibility(View.INVISIBLE);
                }
            } else {
                if (defaultCheckedIndex != -1 && defaultCheckedIndex == position) {
                    mCurrentSelectedTagId = tagViewBean.getId();
                    tagViewBean.setChecked(true);
                    iv_selected.setVisibility(View.VISIBLE);
                } else {
                    tagViewBean.setChecked(false);
                    iv_selected.setVisibility(View.INVISIBLE);
                }
            }
            if (firstInit) {
                firstInit = false;
            }
            btn_meal_kind.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    if (listener != null) {

                        //现将所有Tag点击状态初始化
                        for (int i = 0; i < mInfos.size(); i++) {
                            TagViewBean tagViewBean1 = mInfos.get(i);
                            tagViewBean1.setChecked(false);
                        }

                        tagViewBean.setChecked(true);
                        mCurrentSelectedTagId = tagViewBean.getId();
                        listener.onClickChecked(tagViewBean);

                        notifyDataSetChanged();
                    }
                }
            });
        }
    }

    private OnClickCheckedListener listener;

    public void setOnClickCheckedListener(OnClickCheckedListener listener) {
        this.listener = listener;
    }

    public interface OnClickCheckedListener {
        void onClickChecked(TagViewBean tagViewBean);
    }

    public void setDefaultCheckedIndex(int defaultCheckedIndex) {
        this.defaultCheckedIndex = defaultCheckedIndex;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
        setItemWidth();
    }

    public void setItemWidth() {
        this.itemWidth = showLayoutWidth - ArmsUtils.dip2px(mContext, 5) / colCount;
    }

    public void setShowLayoutWidth(int showLayoutWidth) {
        this.showLayoutWidth = showLayoutWidth;
    }

    public void setItemHegiht(int itemHegiht) {
        this.itemHegiht = itemHegiht;
    }

    public int getCurrentSelectedTagId() {
        return mCurrentSelectedTagId;
    }
}
