package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.ViewUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/31
 * 修订历史：2018/8/31
 * 描述：
 */

public class TableAdapter extends DefaultAdapter<TableBean.DataBean> {

    private Context mContext;

    //当前功能（1：所有餐台、2：餐台带状态）
    private int mFunction;

    //Item行数（行数根据数据自动计算）
    private int ItemRowCount = 6;
    //Item高度
    private int ItemColHeight;

    //展示的布局高度
    private float mDiaplayScreenHeight;

    private int mTableTextSize;

    private int style;

    public TableAdapter(Context context, List<TableBean.DataBean> infos, float diaplayScreenHeight, int function) {
        super(infos);
        this.mContext = context;
        this.mFunction = function;
        this.mDiaplayScreenHeight = diaplayScreenHeight;
        this.mTableTextSize = 38;

        initItemDispalyHeight();
    }

    public void initItemDispalyHeight() {
        float screenHeight = mDiaplayScreenHeight - 75 - 75;
        ItemColHeight = (int) Math.ceil((double) screenHeight / (double) (ItemRowCount));
        ItemColHeight = ItemColHeight - 3;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<TableBean.DataBean> getHolder(View v, int viewType) {
        return new TableItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.table_recycler_table;
    }

    class TableItemHolder extends BaseHolder<TableBean.DataBean> {

        @BindView(R2.id.fl_container)
        RelativeLayout fl_container;
        @BindView(R2.id.btn_table)
        Button btn_table;
        @BindView(R2.id.btn_showMain)
        Button btn_showMain;
        @BindView(R2.id.iv_vip)
        ImageView iv_vip;
        @BindView(R2.id.tv_scan_flag)
        TextView tv_scan_flag;

        public TableItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(TableBean.DataBean item, int position) {

            initItemData(item);
            initItemDispalyMetrics();
            initItemTableClick(item, position);
            initTableBackground(item);
        }

        private void initItemData(TableBean.DataBean item) {

            btn_table.setText(item.getTableName());

//            if (item.getMainshowtable().equals("")) {
//                if (btn_showMain.getVisibility() != View.GONE) {
//                    btn_showMain.setVisibility(View.GONE);
//                }
                if (btn_table.getGravity() != Gravity.CENTER) {
                    btn_table.setGravity(Gravity.CENTER);
                    RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) btn_table.getLayoutParams();
                    lp.height = ItemColHeight;
                    btn_table.setLayoutParams(lp);
                }
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) btn_table.getLayoutParams();
                btn_table.setLayoutParams(lp);
//            } else {
//                if (btn_showMain.getVisibility() == View.VISIBLE) {
//                    return;
//                }
//                btn_showMain.setVisibility(View.VISIBLE);
//                btn_showMain.setText("(" + item.getMainshowtable() + ")");
//                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) btn_table.getLayoutParams();
//                int heee = (int) Math.ceil(ItemColHeight * 70 / 100);
//                lp.height = heee;
//                btn_table.setLayoutParams(lp);
//
//                lp = (RelativeLayout.LayoutParams) btn_showMain.getLayoutParams();
//                lp.height = ItemColHeight - heee;//(int)Math.ceil(this.height*30/100)+1;
//                btn_showMain.setLayoutParams(lp);
//
//                if (style != 0) {
//                    btn_table.setTextSize(20);
//                }
//            }

//            if (!TextUtils.isEmpty(item.getQrCode())) {
//                setTableFlagDispalyLayout(item);
//                tv_scan_flag.setVisibility(View.VISIBLE);
//            } else {
//                //不是skyorder台才显示vip标识
//                if (item.getMemberId() != 0) {
//                    iv_vip.setVisibility(View.VISIBLE);
//                } else {
//                    iv_vip.setVisibility(View.GONE);
//                }
//                tv_scan_flag.setVisibility(View.GONE);
//            }
        }

        private void initTableBackground(TableBean.DataBean item) {

//            if (item.getClearstate() > 0) {
//                setBackGroundWork(item, "Cleaning", R.drawable.tablebutton_splite, R.drawable.tablebutton_splite_new, R.color.black);
//                return;
//            }

//            if (item.getSplitStatus() != 0) {
//                setBackGroundWork(item, "888", R.drawable.tablebutton_splite, R.drawable.tablebutton_splite_new, R.color.black);
//            } else {
//                if (item.getStatus() == true) {
//                    setBackGroundWork(item, "999", R.drawable.tablebutton_red, R.drawable.tablebutton_red_new, R.color.black);
//                } else {
            switch (item.getStatus()) {
                case 0:
                    setBackGroundWork(item, "0", R.drawable.tablebutton_skyblue, R.drawable.tablebutton_skyblue_new, R.color.theme_white_color);
                    break;
                case 1:
                    setBackGroundWork(item, "1", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                    break;
                case 2:
                    setBackGroundWork(item, "2", R.drawable.tablebutton_glassgreen, R.drawable.tablebutton_glassgreen_new, R.color.theme_black);
                    break;
                case 3:
                    setBackGroundWork(item, "3", R.drawable.tablebutton_yellow, R.drawable.tablebutton_yellow_new, R.color.theme_black);
                    break;
                case 4:
                    setBackGroundWork(item, "4", R.drawable.tablebutton_violet, R.drawable.tablebutton_violet_new, R.color.theme_black);
                    break;
                case 5:
                    setBackGroundWork(item, "5", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                    break;
                case 6:
                    setBackGroundWork(item, "6", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                    break;
            }
//                }
        }

        private void initItemTableClick(TableBean.DataBean item, int position) {
            btn_table.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    if(ViewUtils.isFastClick5()) {
                        if (mOnItemClickListener != null) {
                            mOnItemClickListener.onItemClick(item, position);
                        }
                    }
                }
            });
        }

        private void initItemDispalyMetrics() {

            btn_table.setMinimumHeight(ItemColHeight);
            btn_table.setHeight(ItemColHeight);
            btn_table.setTextSize(mTableTextSize);

            RelativeLayout.LayoutParams relativeLayout = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
            relativeLayout.height = ItemColHeight;
            btn_table.setLayoutParams(relativeLayout);
        }

        private void setTableFlagDispalyLayout(TableBean.DataBean item) {
//            GradientDrawable drawable = new GradientDrawable();
//            drawable.setColor(Color.parseColor(GSAApplication.androidSetting.getQRTable_FlagTextBackGroup()));
//            tv_scan_flag.setBackground(drawable);
//
//            RelativeLayout.LayoutParams relativeLayout = (RelativeLayout.LayoutParams) tv_scan_flag.getLayoutParams();
//            relativeLayout.height = ArmsUtils.dip2px(mContext, GSAApplication.androidSetting.getQRTable_FlagHeight());
//            relativeLayout.width = ArmsUtils.dip2px(mContext, GSAApplication.androidSetting.getQRTable_FlagWith());
//            tv_scan_flag.setLayoutParams(relativeLayout);
//
//            tv_scan_flag.setText(GSAApplication.androidSetting.getQRTable_FlagText());
//            tv_scan_flag.setTextSize(GSAApplication.androidSetting.getQRTable_FlagTextSize());
//
//            if (!TextUtils.isEmpty(item.getQrCode())) {
//                if (item.getMemberId() != 0) {
//                    //未登入会员
//                    if (item.getOrderid() > 0 && item.getRiceponorderid() > 0) {
//                        //已送单（橙色底黑色“S”）
//                        //橙色底黑色字“S”=SKY ORDER未登錄會員
//                        tv_scan_flag.setTextColor(Color.parseColor("#000000"));
//                        tv_scan_flag.setBackgroundColor(Color.parseColor("#FF7F04"));
//                    }else {
//                        //未送单（蓝色底黑色“S”）
//                        //藍色底黑色字“S”=SKY ORDER未登錄會員
//                        tv_scan_flag.setTextColor(Color.parseColor("#000000"));
//                        tv_scan_flag.setBackgroundColor(Color.parseColor("#0404FF"));
//                    }
//                } else {
//                    //已登入会员
//                    if (item.getOrderid() > 0 && item.getRiceponorderid() > 0) {
//                        //已送单（橙色底白色“S”）
//                        tv_scan_flag.setTextColor(Color.parseColor("#FFFFFF"));
//                        tv_scan_flag.setBackgroundColor(Color.parseColor("#FF7F04"));
//                    } else {
//                        //未送单（蓝色底白色“S”）
//                        tv_scan_flag.setTextColor(Color.parseColor("#FFFFFF"));
//                        tv_scan_flag.setBackgroundColor(Color.parseColor("#0404FF"));
//                    }
//                }
//            }
        }

        private void setBackGroundWork(TableBean.DataBean item, String workstatu, int defaultMainback, int defaultChildBack, int defaultFontColor) {


            String tableName = item.getTableName();

            if (defaultMainback != -1) {
                fl_container.setBackgroundDrawable(mContext.getResources().getDrawable(defaultMainback));
            }
            if (defaultChildBack != -1) {
                btn_table.setBackgroundDrawable(mContext.getResources().getDrawable(defaultChildBack));
                btn_showMain.setBackgroundDrawable(mContext.getResources().getDrawable(defaultChildBack));
            }
            btn_table.setTextColor(mContext.getResources().getColor(defaultFontColor));
            btn_showMain.setTextColor(mContext.getResources().getColor(defaultFontColor));

            /**
             * 可使用   0
             * 操作中   1
             * 已开台   2
             * 已印单   3
             * 已结账   4
             * 连台     6
             */
            StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
            GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
            switch (workstatu) {
                case "0":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.app_color_blue));
                    break;
                case "1":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.red));
                    break;
                case "2":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.green_500));
                    break;
                case "3":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.yellow_500));
                    break;
                case "4":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.app_color_blue));
                    break;
                case "5":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.app_color_blue));
                    break;
                case "6":
                    d.setColor(ArmsUtils.getColor(mContext,R.color.Violet));
                    break;

            }
//            com.elegant.bin.gsa.mvp.main.model.bean.Color.DatasBean cs;
//
//            for (TableWorkStatusColor tws : GSAApplication.androidSetting.getTableWorkStatusColors()) {
//                if (tws.getWorkstatu().equalsIgnoreCase(workstatu)) {
//                    cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                    if (cs != null) {
//                        StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                        int[] states = bgShape.getState();
//                        for (int i = 0; i < states.length; i++) {
//                            if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                if (!TextUtils.isEmpty(cs.getAndroidColor())) {
//                                    d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                } else {
//                                    d.setColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
//                                }
//                            }
//                        }
//                        bgShape = (StateListDrawable) btn_showMain.getBackground();
//                        states = bgShape.getState();
//                        for (int i = 0; i < states.length; i++) {
//                            if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                if (!TextUtils.isEmpty(cs.getAndroidColor())) {
//                                    d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                } else {
////                                    d.setColor(Color.parseColor(""));
//                                }
//                            }
//                        }
//                        if (!TextUtils.isEmpty(cs.getAndroidfontcolor())) {
//                            btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                        }
//                    }
//                    break;
//                }
//            }
//            if (item.getSplitStatus() == 1 || item.isUsing()) {
//                return;
//            }
//            switch (item.getStatus()) {
//                case 2://开台状态下要增加随时时间增加，改变色的功能
//                    for (TableStatusOpenedOverTime tws : GSAApplication.androidSetting.getTableStatusOpenedOverTimeColors()) {
//                        if (item.getOropentime_diff() >= tws.times) {
//                            cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                            if (cs != null) {
//                                StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                                int[] states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                bgShape = (StateListDrawable) btn_showMain.getBackground();
//                                states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                                btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            }
//                            //break;
//                        }
//                    }
//                    break;
//                case 3://印单状态下要增加随时间增加，改变色的功能
//                    for (TableStatusPrintedOverTime tws : GSAApplication.androidSetting.getTableStatusPrintedOverTimeColors()) {
//                        if (item.getOropentime_diff() >= tws.times) {
//                            cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                            if (cs != null) {
//                                StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                                int[] states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                bgShape = (StateListDrawable) btn_showMain.getBackground();
//                                states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                                btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            }
//                            //break;
//                        }
//                    }
//                    break;
//            }
//        }
        }
    }

    public int getStyle() {
        return style;
    }

    public void setStyle(int style) {
        this.style = style;
    }


    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(TableBean.DataBean datasBean, int position);

    }
}
