package com.gingersoft.gsa.other_order_mode.ui.activity

import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.gingersoft.gsa.cloud.base.utils.time.TimePickerUtils
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.model.viewModel.HistoryOrderViewModel
import com.gingersoft.gsa.other_order_mode.ui.base.BaseActivity
import com.gingersoft.gsa.other_order_mode.ui.fragment.HistoryFragment
import com.gingersoft.gsa.other_order_mode.util.InjectorUtil
import com.google.android.material.tabs.TabLayout
import kotlinx.android.synthetic.main.activity_history_order.*
import java.text.ParseException
import java.util.*

class HistoryOrderActivity : BaseActivity() {

    private lateinit var mViewModel: HistoryOrderViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_history_order)

        tv_start_time.text = TimeUtils.getOldDate(0)
        tv_end_time.text = TimeUtils.getOldDate(0)

        initAppTop()
        initViewModel()
        initSearch()

        history_tabs.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
            override fun onTabUnselected(tab: TabLayout.Tab?) {

            }

            override fun onTabSelected(tab: TabLayout.Tab?) {
                tab?.let { it ->
                    mViewModel.status.postValue(when (it.position) {
                        0 -> "4"
                        1 -> "6"
                        else -> "4"
                    })
                }
            }

            override fun onTabReselected(tab: TabLayout.Tab?) {
            }
        })

        supportFragmentManager.beginTransaction().add(R.id.content_layout, HistoryFragment.newInstance()).commit()
    }

    private fun initViewModel() {
        mViewModel = ViewModelProvider(this, InjectorUtil.getHistoryModelFactory())[HistoryOrderViewModel::class.java].apply {
            historyTime.observe(this@HistoryOrderActivity, androidx.lifecycle.Observer {
                tv_start_time.text = it
            })
        }
    }

    private fun initSearch() {
        iv_search_order.setOnClickListener {
            //搜索
            if (ed_order_num_search.text != null && ed_order_num_search.text.isNotEmpty()) {
                mViewModel.searchValue.postValue(ed_order_num_search.text.toString())
            } else {
                ToastUtils.show(this@HistoryOrderActivity, "請輸入手機號或訂單號")
            }
        }
    }

    private fun initAppTop() {
        qm_other_order_bar.setTitle(R.string.history_order)
        qm_other_order_bar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { finish() }
        qm_other_order_bar.setBackgroundColor(resources.getColor(R.color.theme_color))
    }

    fun onClickListener(v: View?) {
        when (v!!.id) {
            R.id.iv_start_time_triangle, R.id.tv_start_time -> {
                iv_start_time_triangle.toggle()
                val cal = Calendar.getInstance()
                try {
                    //設置默認時間為當前的起止時間
                    cal.time = TimeUtils.DATE_FORMAT_DATE.parse(tv_start_time.text.toString())
                } catch (e: ParseException) {
                    e.printStackTrace()
                }
                TimePickerUtils.showReportTimePicker(this@HistoryOrderActivity, cal) { date, v ->
                    //                    tv_start_time.text = TimeUtils.DATE_FORMAT_DATE.format(date)
//                    time = TimeUtils.DATE_FORMAT_DATE.format(date)
                    mViewModel.historyTime.postValue(TimeUtils.DATE_FORMAT_DATE.format(date))
//                    pageIndex = 1
//                    getHistoryInfo()
                }.setOnDismissListener {
                    iv_start_time_triangle.toggle()
                }
            }
//            R.id.tv_end_time, R.id.iv_end_time_triangle -> {
//                iv_end_time_triangle.toggle()
//                val cal = Calendar.getInstance()
//                try {
//                    //設置默認時間為當前的起止時間
//                    cal.time = TimeUtils.DATE_FORMAT_DATE.parse(tv_end_time.text.toString())
//                } catch (e: ParseException) {
//                    e.printStackTrace()
//                }
//                TimePickerUtils.showReportTimePicker(this@HistoryOrderActivity, cal) { date, v ->
//                    tv_end_time.text = TimeUtils.DATE_FORMAT_DATE.format(date)
//                }.setOnDismissListener {
//                    iv_end_time_triangle.toggle()
//                    pageIndex = 1
//                    getHistoryInfo()
//                }
//            }
        }
    }
}