package com.joe.print.mvp.ui.adapter;

import android.content.Context;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrintBillBean;

import java.util.HashMap;
import java.util.List;

/**
 * Created by Wyh on 2020/1/16.
 */
public class BillItemAdapter extends BaseQuickAdapter<PrintBillBean, BaseViewHolder> {
    private Context mContext;

    public BillItemAdapter(@Nullable List<PrintBillBean> data, Context mContext) {
        super(R.layout.print_item_bill, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, PrintBillBean item) {
        helper.setText(R.id.print_bill_name, item.getBillName());
        helper.setText(R.id.print_bill_value, item.getBillAmount());
    }
}
