package com.gingersoft.gsa.other_order_mode.data.network.api

import com.gingersoft.gsa.cloud.print.bean.OrderDetails
import com.gingersoft.gsa.other_order_mode.data.model.bean.*
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.POST

interface WeatherService {

    @POST("wechat/findOrderList")
    fun getOrderList(@Body requestBody: RequestBody): Call<OrderList>

    @POST("wx/updateRestOpenStatus")
    fun updateRestOpenStatus(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("wechat/findOrderGroup")
    fun getOrderGroupNum(@Body requestBody: RequestBody): Call<OrderGoupNumBean>

    @POST("wechat/findOrderDetails")
    fun getOrderDesc(@Body requestBody: RequestBody): Call<OrderDetails>

    @POST("gsa/calculateEstimatedTime")
    fun getShipanyOrderTime(@Body requestBody: RequestBody): Call<EstimatedBean>

    @POST("wechat/updateOrderStatus")
    fun updateOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("order/updateOrderStatus")
    fun gsUpdateOrderStatus(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("gsa/shipAnyOrdersNew")
    fun thirdDelivery(@Body requestBody: RequestBody): Call<ThirdSend>

    @POST("order/updateOrderInfoIsRead")
    fun updateIsRead(@Body requestBody: RequestBody):Call<String>

    @POST("wechat/updateSelfOrderStatus")
    fun updateSelfOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("wechat/findRestDelivery")
    fun getDeliveryInfo(@Body requestBody: RequestBody): Call<DeliveryBean>

    @POST("gsa/getDeliveryConfigDTO")
    fun getDeliveryConfigDTO(@Body requestBody: RequestBody): Call<DeliveryConfig>

    @POST("wechat/findHistoryOrderList")
    fun getHistoryOrderList(@Body requestBody: RequestBody): Call<HistoryOrderBean>

    @POST("gsa/cancelOrder")
    fun cancelLogistics(@Body requestBody: RequestBody): Call<CancelLogisticsBean>

    @POST("order/updateOrderStatus")
    fun cancelOrder(@Body requestBody: RequestBody): Call<CancelLogisticsBean>

    @POST("restaurantFoodReason/config/list")
    fun getCancelReason(@Body requestBody: RequestBody): Call<CancelReason>

    @POST("order/confirmPay")
    fun getPayMethod(@Body requestBody: RequestBody): Call<PayTypeInfo>

    @POST("printerRecording/add")
    fun addPrj(@Body requestBody: RequestBody): Call<String>
}