package com.gingersoft.gsa.other_order_mode.ui.adapter

import androidx.core.content.ContextCompat
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.BillBean

class PayBillAdapter(billBeans: MutableList<BillBean>) : BaseQuickAdapter<BillBean, BaseViewHolder>(R.layout.item_pay_bill, billBeans) {

    override fun convert(holder: BaseViewHolder, item: BillBean) {
        holder.setText(R.id.tv_item_pay_name, item.name)
        holder.setText(R.id.tv_item_pay_amount, item.amount.toString())
        if(item.isRed == 0){
            holder.setTextColor(R.id.tv_item_pay_name, ContextCompat.getColor(context, R.color.color_3c))
            holder.setTextColor(R.id.tv_item_pay_name, ContextCompat.getColor(context, R.color.color_3c))
        } else {
            holder.setTextColor(R.id.tv_item_pay_name, ContextCompat.getColor(context, R.color.discount_red))
            holder.setTextColor(R.id.tv_item_pay_name,ContextCompat.getColor(context, R.color.discount_red))
        }
    }

}