package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderPayContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderPayService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/09/2020 19:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderPayModel extends BaseModel implements OrderPayContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderPayModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getPayMethods(int brandId,int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .getPayMethods(brandId,restaurantId);
    }

    @Override
    public Observable<BaseResult> updateOrderPay( RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrderPay(requestBody);
    }

    @Override
    public Observable<BaseRespose> calculationPrice(long orderId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .calculationPrice(orderId);
    }

    @Override
    public Observable<BaseResult> createOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .createOrder(requestBody);
    }

    @Override
    public Observable<BaseResult> addFood(RequestBody requestBody) {
        Observable ob = mRepositoryManager.obtainRetrofitService(MealService.class)
                .addFood(requestBody);
//        if (MyOrderManage.getInstance().isModifyOrder()) {
//            /**
//             * 修改訂單
//             * 添加食品后更新總金額
//             */
//            ob.flatMap(new Function<BaseResult, Observable<BaseRespose>>() {
//                @Override
//                public Observable<BaseRespose> apply(BaseResult info) throws Exception {
//                    if (info != null && info.isSuccess()) {
//                        return calculationPrice(MyOrderManage.getInstance().getOrderId());
//                    }
//                    return null;
//                }
//            });
//        }
        return ob;
    }

    @Override
    public Observable<BaseResult> toOrderPay(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .toOrderPay(formBody);
    }

    @Override
    public Observable<BaseResult> updateOrder(RequestBody formBody) {
        return mRepositoryManager.obtainRetrofitService(OrderPayService.class)
                .updateOrder(formBody);
    }

}