package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.net.ParseException;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodReason;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.FoodReasonAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.DiscountAdapter;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.jess.arms.base.DefaultAdapter;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.layout.QMUIRelativeLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUIEmptyView;
import com.qmuiteam.qmui.widget.QMUISlider;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;

import org.json.JSONException;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-28
 * 修订历史：2020-03-28
 * 描述：
 */
public class DiscountDialog extends Dialog {

    private static final String TAG = "DiscountDialog";

    public DiscountDialog(@NonNull Context context) {
        super(context, R.style.MyDialogTheme2);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    public static class Builder implements View.OnClickListener {

        private Context mContext;
        private DiscountDialog mDialog;

        private int spanCount = 3;

        private int mRadius;
        private float mShadowAlpha = 0.25f;
        private int mShadowElevationDp = 14;
        private int mBagcolor;

        private List<Discount> mItems;
        private DiscountAdapter mAdapter;

        private QMUITopBar mTopBar;
        private QMUILinearLayout ll_container;
        private RecyclerView recycler_discount;
        private ImageView btn_close;

        public Builder(Context context) {
            mContext = context;
            mItems = new ArrayList<>();
            mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
        }

        public void addItem(Discount item) {
            mItems.add(item);
        }

        public void addItems(List<Discount> items) {
            if (mItems.size() > 0)
                mItems.clear();
            mItems.addAll(items);
        }

        @Override
        public void onClick(View v) {
        }

        public DiscountDialog build() {
            if (mDialog != null) {
                return mDialog;
            }
            mDialog = new DiscountDialog(mContext);
            View contentView = buildViews();
            int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.6);
            mDialog.setContentView(contentView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, screenHeight));
            return mDialog;
        }

        private View buildViews() {
            View view = View.inflate(mContext, getContentViewLayoutId(), null);
            mTopBar = view.findViewById(R.id.topbar);
            recycler_discount = view.findViewById(R.id.recycler_discount);
            ll_container = view.findViewById(R.id.ll_container);
//            btn_close = view.findViewById(R.id.btn_close);
//            btn_close.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    closeDialog() ;
//                }
//            });
            ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

            initTopbar();
            initDiscountRecycleView();
            return view;
        }

        private void initTopbar() {
            if (mBagcolor != 0) {
                mTopBar.setBackgroundColor(mBagcolor);
            } else {
                mTopBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
            }
            mTopBar.setTitle("折扣");
        }

        private void initDiscountRecycleView() {
            if (mAdapter == null) {
                mAdapter = new DiscountAdapter(mContext, mItems);
            }
            mAdapter.setOnItemClickListener(new DefaultAdapter.OnRecyclerViewItemClickListener() {
                @Override
                public void onItemClick(View view, int viewType, Object data, int position) {
                    if (onClickListener != null) {
                        onClickListener.onItemClick((Discount) data, position);
                    }
                    closeDialog();
                }
            });
            recycler_discount.setLayoutManager(createLayoutManager());
            recycler_discount.setAdapter(mAdapter);
        }

        private RecyclerView.LayoutManager createLayoutManager() {
            return new GridLayoutManager(mContext, spanCount, LinearLayoutManager.VERTICAL, false) {
                @Override
                public RecyclerView.LayoutParams generateDefaultLayoutParams() {
                    return new RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                }
            };
        }

        public void closeDialog() {
            mDialog.dismiss();
        }

        public void setTopBarBagcolor(int mBagcolor) {
            this.mBagcolor = mBagcolor;
        }

        protected int getContentViewLayoutId() {
            return R.layout.table_dialog_discout;
        }


        private OnClickListener onClickListener;

        public void setOnClickListener(OnClickListener onClickListener) {
            this.onClickListener = onClickListener;
        }

        public interface OnClickListener {

            void onItemClick(Discount item, int position);

        }
    }

}
