package com.gingersoft.gsa.cloud.pay.pos.hyweb.imp;

import android.app.Activity;
import android.content.Context;

import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.PosCallbackListener;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.bean.request.pos.PrintPaymentStubRequest;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.bean.response.pos.HywebPosResponse;
import com.jess.arms.mvp.IView;

/**
 * @作者: bin
 * @創建時間: 2021-01-12 14:47
 * @更新時間: 2021-01-12 14:47
 * @描述:
 */
public class PrintPaymentStubImpl extends IHywebAction {

    private String mTxnId;

    public PrintPaymentStubImpl(Context context, IView iView, PayAction action, String txnId, PosCallbackListener onPosActionListener, boolean showLoading) {
        super(context, iView, action, showLoading);
        this.mTxnId = txnId;
        this.mOnPosActionListener = onPosActionListener;
    }

    @Override
    public void onPosActionBefore() {
        //打印存根
        PrintPaymentStubRequest stub = new PrintPaymentStubRequest();
        stub.setTXN_ID(mTxnId);
        onPosToAction(GsonUtils.GsonString(stub));
    }

    @Override
    public void onPosSuccess(Context context, Activity originalActivity, HywebPosResponse response) {
        super.onPosSuccess(context, originalActivity, response);
    }

    @Override
    public void onPosException(Context context, Activity originalActivity, HywebPosResponse response) {
        super.onPosException(context, originalActivity, response);
    }

    @Override
    public void onPosInvalid(Context context, Activity originalActivity, HywebPosResponse response) {
        super.onPosInvalid(context, originalActivity, response);
    }
}
