package com.joe.base.widget.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.Spanned;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;

import com.joe.base.R;
import com.joe.base.utils.other.TextUtil;
import com.joe.base.utils.toast.ToastUtils;

import java.util.ArrayList;
import java.util.List;

import androidx.appcompat.widget.AppCompatEditText;

/**
 * Created by Wyh on 2019/12/19.
 */
public class MyEditText extends AppCompatEditText {

    private Context context;
    //輸入最大長度
    private int maxLeght;

    private String maxLengthTip;
    //是否顯示輸入最大字數限制
    private boolean isShowMaxLenght;
    private int maxLenghtTextColor;
    private int maxLenghtTextSize;
    //是否允許輸入表情
    private boolean isInputIcon;
    //輸入表情時提示的內容，不設置內容不提示
    private String inputIconTipText;

    //清除按鈕的大小
    private int clearIconSiZe;
    //清除按鈕圖標
    private Drawable clearIcon;
    //清除按鈕右間距
    private int clearRightMargin;
    //清除按鈕點擊事件
    private View.OnClickListener clearOnClickListener;

    //查看密碼按鈕圖標
    private Drawable lookIcon;
    //"查看密碼"圖標的大小
    private int lookIconSiZe;
    //查看密碼按鈕右間距
    private int lookRightMargin;
    //查看密碼按鈕點擊事件
    private OnClickListener lookOnClickListener;

    //設置輸入密碼替換符
    private String pwdChar;
    //是否換行
    private boolean singLeLine;

    private int inputType;

//    private EditText editText;
    //顯示最大字數的textview
//    private TextView maxLenghtTextView;
//
//    private ImageView ivClear;
//    private ImageView ivLook;

    private List<InputFilter> mInputFilter = new ArrayList<>();


    public MyEditText(Context context) {
        this(context, null);
    }

    public MyEditText(Context context, AttributeSet attrs) {
        this(context, attrs, -1);//R.attr.editTextStyle
    }

    public MyEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MyEditText);
        maxLeght = typedArray.getInt(R.styleable.MyEditText_ed_MaxLength, 0);
        maxLengthTip = typedArray.getString(R.styleable.MyEditText_ed_MaxLengthTip);

        isShowMaxLenght = typedArray.getBoolean(R.styleable.MyEditText_ed_showMaxLenght, false);
        maxLenghtTextColor = typedArray.getColor(R.styleable.MyEditText_ed_maxLengthTextColor, -1);
        maxLenghtTextSize = typedArray.getDimensionPixelSize(R.styleable.MyEditText_ed_maxLengthTextSize, 12);

        isInputIcon = typedArray.getBoolean(R.styleable.MyEditText_ed_isInputIcon, false);
        inputIconTipText = typedArray.getString(R.styleable.MyEditText_ed_putIconTip);

        clearIconSiZe = typedArray.getDimensionPixelSize(R.styleable.MyEditText_ed_clearIconSize, 12);
        clearIcon = typedArray.getDrawable(R.styleable.MyEditText_ed_clearRes);
        clearRightMargin = typedArray.getDimensionPixelSize(R.styleable.MyEditText_ed_clearMarginRight, 0);

        lookIcon = typedArray.getDrawable(R.styleable.MyEditText_ed_lookIcon);
        lookIconSiZe = typedArray.getDimensionPixelSize(R.styleable.MyEditText_ed_lookIconSize, 12);
        lookRightMargin = typedArray.getDimensionPixelSize(R.styleable.MyEditText_ed_lookMarginRight, 0);

        pwdChar = typedArray.getString(R.styleable.MyEditText_ed_pwdChar);

        singLeLine = typedArray.getBoolean(R.styleable.MyEditText_ed_singLeLine, false);

        inputType = typedArray.getInteger(R.styleable.MyEditText_inputType, 0);

        typedArray.recycle();

        initLeght();

        if (!isInputIcon) {
            mInputFilter.add(new EmojiInputFilter());
        }
        initEditText();
    }

    private void initEditText() {
        InputFilter[] inputFilters = new InputFilter[mInputFilter.size()];
        if (!TextUtil.isEmptyOrNullOrUndefined(pwdChar)) {
            this.setInputType(InputType.TYPE_NUMBER_VARIATION_PASSWORD);
            this.setTransformationMethod(new AsteriskPasswordTransformationMethod());
        }
        for (int i = 0; i < mInputFilter.size(); i++) {
            inputFilters[i] = mInputFilter.get(i);
        }
        setFilters(inputFilters);
        setSingleLine(singLeLine);


//        if (clearIcon != null) {
//            ivClear = new ImageView(context);
//            ivClear.setImageDrawable(clearIcon);
//            ivClear.setLayoutParams(getImgLayoutParams(clearIconSiZe, clearIconSiZe, clearRightMargin));
//            this.addView(ivClear);
//            ivClear.setOnClickListener(new OnClickListener() {
//                @Override
//                public void onClick(View view) {
//                    editText.setText("");
//                    if (clearOnClickListener != null) {
//                        clearOnClickListener.onClick(view);
//                    }
//                }
//            });
//        }
//
//
//        if (lookIcon != null) {
//            ivLook = new ImageView(context);
//            LayoutParams ivLookParams = getImgLayoutParams(lookIconSiZe, lookIconSiZe, lookRightMargin);
//            if (ivClear != null) {
//                ivLookParams.rightMargin = clearIconSiZe + lookRightMargin;
//            }
//            ivLook.setLayoutParams(ivLookParams);
//            ivLook.setImageDrawable(lookIcon);
//            this.addView(ivLook);
//            ivLook.setOnClickListener(new OnClickListener() {
//                @Override
//                public void onClick(View view) {
//                    if (lookOnClickListener != null) {
//                        lookOnClickListener.onClick(view);
//                    }
//                }
//            });
//        }
    }


    private void initLeght() {
        if (maxLeght > 0) {
            mInputFilter.add(new MaxTextLengthFilter(maxLeght));
        }
    }

    /**
     * 检测是否有emoji表情
     *
     * @param source
     * @return
     */
    private boolean containsEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (!isEmojiCharacter(codePoint)) { //如果不能匹配,则该字符是Emoji表情
                return true;
            }
        }
        return false;
    }

    /**
     * 判断是否是Emoji
     *
     * @param codePoint 比较的单个字符
     * @return
     */
    private boolean isEmojiCharacter(char codePoint) {
        return codePoint == 0x0 || codePoint == 0x9 || codePoint == 0xA || codePoint == 0xD || codePoint >= 0x20 && codePoint <= 0xD7FF || codePoint >= 0xE000 && codePoint <= 0xFFFD;
    }


    public void setClearOnClickListener(OnClickListener clearOnClickListener) {
        this.clearOnClickListener = clearOnClickListener;
    }


    public void setLookOnClickListener(OnClickListener lookOnClickListener) {
        this.lookOnClickListener = lookOnClickListener;
    }

    //最大字數限制器
    class MaxTextLengthFilter implements InputFilter {
        private int mMaxLength;

        public MaxTextLengthFilter(int max) {
            mMaxLength = max;
        }

        public CharSequence filter(CharSequence source, int start, int end,
                                   Spanned dest, int dstart, int dend) {
            int keep = mMaxLength - (dest.length() - (dend - dstart));
            if (keep < (end - start)) {
                if (!TextUtil.isEmptyOrNullOrUndefined(maxLengthTip)) {
                    ToastUtils.show(context, maxLengthTip);
                }
            }
            if (keep <= 0) {
                return "";
            } else if (keep >= end - start) {
                return null;
            } else {
                return source.subSequence(start, start + keep);
            }
        }
    }

    class EmojiInputFilter implements InputFilter {

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (containsEmoji(source.toString())) {
                //如果輸入了表情
                if (!TextUtil.isEmptyOrNullOrUndefined(inputIconTipText)) {
                    //提示文字不為空，就彈出提示,並移除掉表情
                    ToastUtils.show(context, inputIconTipText);
                    return "";
                }
                return "";
            }
            return source;
        }
    }

    //替換密碼輸入框顯示的密碼樣式
    public class AsteriskPasswordTransformationMethod extends PasswordTransformationMethod {
        @Override
        public CharSequence getTransformation(CharSequence source, View view) {
            return new PasswordCharSequence(source);
        }

        private class PasswordCharSequence implements CharSequence {
            private CharSequence mSource;

            public PasswordCharSequence(CharSequence source) {
                mSource = source;
            }

            public char charAt(int index) {
                return pwdChar.toCharArray()[0];
            }

            public int length() {
                return mSource.length();
            }

            public CharSequence subSequence(int start, int end) {
                return mSource.subSequence(start, end);
            }

        }
    }


}
