/*
 * Decompiled with CFR 0.152.
 */
package com.hyweb.n5.lib.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.hyweb.n5.lib.exception.NoInitDeviceException;
import com.hyweb.n5.server.aidl.IDeviceInfoService;
import java.util.List;

public class DeviceUtil {
    private static IDeviceInfoService mDeviceService;
    private static ServiceConnection mServiceConnection;

    static {
        mServiceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                mDeviceService = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                mDeviceService = IDeviceInfoService.Stub.asInterface(service);
            }
        };
    }

    private static void bindDeviceService(Context context) {
        Intent implicitIntent;
        Context localContext = context.getApplicationContext();
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent = new Intent("com.hyweb.n5.server.aidl.IDeviceInfoService"), 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        localContext.bindService(explicitIntent, mServiceConnection, 1);
    }

    public static void unbindDeviceService(Context context) {
        context.unbindService(mServiceConnection);
    }

    public static void initDevice(Context context) throws NoInitDeviceException, RemoteException {
        DeviceUtil.bindDeviceService(context);
        if (mDeviceService == null) {
            throw new NoInitDeviceException();
        }
    }

    public static String getSerialNo() throws RemoteException {
        return mDeviceService.getSerialNo();
    }
}

